/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.qywx.api.core.util;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.internal.util.StringUtils;
import com.jeecg.qywx.api.base.JwAccessTokenAPI;
import com.jeecg.qywx.api.base.JwParamesAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class WXUpload {
    private static final String upload_wechat_url = "https://qyapi.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";

    public static JSONObject upload(String accessToken, String type, String fileUrl) {
        JSONObject jsonObject = null;
        String last_wechat_url = upload_wechat_url.replace("ACCESS_TOKEN", accessToken).replace("TYPE", type);
        String boundary = "----------sunlight";
        try {
            URL uploadUrl = new URL(last_wechat_url);
            HttpURLConnection uploadConn = (HttpURLConnection)uploadUrl.openConnection();
            uploadConn.setDoOutput(true);
            uploadConn.setDoInput(true);
            uploadConn.setRequestMethod("POST");
            uploadConn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            OutputStream outputStream = uploadConn.getOutputStream();
            URL mediaUrl = new URL(fileUrl);
            HttpURLConnection meidaConn = (HttpURLConnection)mediaUrl.openConnection();
            meidaConn.setDoOutput(true);
            meidaConn.setRequestMethod("GET");
            String contentType = meidaConn.getHeaderField("Content-Type");
            String filename = WXUpload.getFileName(fileUrl, contentType);
            outputStream.write(("--" + boundary + "\r\n").getBytes());
            outputStream.write(String.format("Content-Disposition: form-data; name=\"media\"; filename=\"%s\"\r\n", filename).getBytes());
            outputStream.write(String.format("Content-Type: %s\r\n\r\n", contentType).getBytes());
            BufferedInputStream bis = new BufferedInputStream(meidaConn.getInputStream());
            byte[] buf = new byte[8192];
            int size = 0;
            while ((size = bis.read(buf)) != -1) {
                outputStream.write(buf, 0, size);
            }
            outputStream.write(("\r\n--" + boundary + "--\r\n").getBytes());
            outputStream.close();
            bis.close();
            meidaConn.disconnect();
            InputStream inputStream = uploadConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer buffer = new StringBuffer();
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            uploadConn.disconnect();
            jsonObject = JSONObject.parseObject((String)buffer.toString());
            System.out.println("jsonobject=" + jsonObject);
        }
        catch (Exception e) {
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return jsonObject;
    }

    public static String getFileName(String fileUrl, String contentType) {
        String filename = "";
        if (fileUrl != null && !"".equals(fileUrl)) {
            if (fileUrl.contains(".")) {
                filename = fileUrl.substring(fileUrl.lastIndexOf("/") + 1);
            } else {
                if (contentType == null || "".equals(contentType)) {
                    return "";
                }
                String fileExt = "";
                if ("image/jpeg".equals(contentType)) {
                    fileExt = ".jpg";
                } else if ("audio/mpeg".equals(contentType)) {
                    fileExt = ".mp3";
                } else if ("audio/amr".equals(contentType)) {
                    fileExt = ".amr";
                } else if ("video/mp4".equals(contentType)) {
                    fileExt = ".mp4";
                } else if ("video/mpeg4".equals(contentType)) {
                    fileExt = ".mp4";
                } else if ("text/plain".equals(contentType)) {
                    fileExt = ".txt";
                } else if ("text/xml".equals(contentType)) {
                    fileExt = ".xml";
                } else if ("application/pdf".equals(contentType)) {
                    fileExt = ".pdf";
                } else if ("application/msword".equals(contentType)) {
                    fileExt = ".doc";
                } else if ("application/vnd.ms-powerpoint".equals(contentType)) {
                    fileExt = ".ppt";
                } else if ("application/vnd.ms-excel".equals(contentType)) {
                    fileExt = ".xls";
                }
                filename = "Media\u6587\u4ef6" + fileExt;
            }
        }
        return filename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeFile(byte[] data, String dir, String filename, boolean cover) {
        try {
            File file;
            if (StringUtils.isEmpty((String)dir)) {
                throw new Exception("\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)filename)) {
                throw new Exception("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            File dirfile = new File(dir);
            if (dirfile.isFile()) {
                throw new Exception("\u76ee\u5f55\u4e0d\u80fd\u662f\u6587\u4ef6");
            }
            if (!dirfile.exists()) {
                dirfile.mkdirs();
            }
            if ((file = new File(dir + "//" + filename)).exists()) {
                if (!cover) return;
                file.setWritable(true);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(data);
                bufferedOutputStream.close();
                return;
            } else {
                file.setWritable(true);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(data);
                bufferedOutputStream.close();
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        AccessToken accessToken = JwAccessTokenAPI.getAccessToken(JwParamesAPI.corpId, JwParamesAPI.secret);
        JSONObject object = WXUpload.upload(accessToken.getAccesstoken(), "image", "http://127.0.0.1:80/jeecg-p3-web/upload/shjjj.jpg");
        System.out.println(object.toString());
    }
}

