/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONHelper {
    private static final Logger logger = LoggerFactory.getLogger(JSONHelper.class);

    public static String bean2json(Object object) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)object));
        return jsonObject.toString();
    }

    public static <T> String toJSONString(List<T> list) {
        return JSON.toJSONString(list);
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static String toJSONString(JSONArray jsonArray) {
        return jsonArray.toString();
    }

    public static String toJSONString(JSONObject jsonObject) {
        return jsonObject.toString();
    }

    public static JSONObject toJSONObject(Object object) {
        return JSONObject.parseObject((String)JSON.toJSONString((Object)object));
    }

    public static List<Map<String, Object>> toList(Object object) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)object));
        for (Object obj : jsonArray) {
            JSONObject jsonObject = (JSONObject)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : jsonObject.keySet()) {
                Object value = jsonObject.get((Object)key);
                map.put(key, value);
            }
            list.add(map);
        }
        return list;
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> objectClass) {
        return jsonArray.toJavaList(objectClass);
    }

    public static <T> List<T> toList(Object object, Class<T> objectClass) {
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)object));
        return jsonArray.toJavaList(objectClass);
    }

    public static <T> T toBean(JSONObject jsonObject, Class<T> beanClass) {
        return (T)jsonObject.toJavaObject(beanClass);
    }

    public static <T> T toBean(Object object, Class<T> beanClass) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)object));
        return (T)jsonObject.toJavaObject(beanClass);
    }

    public static <T, D> T toBean(String jsonString, Class<T> mainClass, String detailName, Class<D> detailClass) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        JSONArray jsonArray = (JSONArray)jsonObject.get((Object)detailName);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D> detailList = JSONHelper.toList(jsonArray, detailClass);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName, detailList);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T, D1, D2> T toBean(String jsonString, Class<T> mainClass, String detailName1, Class<D1> detailClass1, String detailName2, Class<D2> detailClass2) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        JSONArray jsonArray1 = (JSONArray)jsonObject.get((Object)detailName1);
        JSONArray jsonArray2 = (JSONArray)jsonObject.get((Object)detailName2);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D1> detailList1 = JSONHelper.toList(jsonArray1, detailClass1);
        List<D2> detailList2 = JSONHelper.toList(jsonArray2, detailClass2);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName1, detailList1);
            BeanUtils.setProperty(mainEntity, (String)detailName2, detailList2);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T, D1, D2, D3> T toBean(String jsonString, Class<T> mainClass, String detailName1, Class<D1> detailClass1, String detailName2, Class<D2> detailClass2, String detailName3, Class<D3> detailClass3) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        JSONArray jsonArray1 = (JSONArray)jsonObject.get((Object)detailName1);
        JSONArray jsonArray2 = (JSONArray)jsonObject.get((Object)detailName2);
        JSONArray jsonArray3 = (JSONArray)jsonObject.get((Object)detailName3);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D1> detailList1 = JSONHelper.toList(jsonArray1, detailClass1);
        List<D2> detailList2 = JSONHelper.toList(jsonArray2, detailClass2);
        List<D3> detailList3 = JSONHelper.toList(jsonArray3, detailClass3);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName1, detailList1);
            BeanUtils.setProperty(mainEntity, (String)detailName2, detailList2);
            BeanUtils.setProperty(mainEntity, (String)detailName3, detailList3);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T> T toBean(String jsonString, Class<T> mainClass, HashMap<String, Class> detailClass) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        for (String key : detailClass.keySet()) {
            try {
                Class value = detailClass.get(key);
                BeanUtils.setProperty(mainEntity, (String)key.toString(), (Object)value);
            }
            catch (Exception ex) {
                throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
            }
        }
        return mainEntity;
    }
}

