/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.qywx.api.department;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.qywx.api.base.JwAccessTokenAPI;
import com.jeecg.qywx.api.base.JwParamesAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import com.jeecg.qywx.api.core.util.HttpUtil;
import com.jeecg.qywx.api.department.vo.DepartMsgResponse;
import com.jeecg.qywx.api.department.vo.Department;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwDepartmentAPI {
    private static final Logger logger = LoggerFactory.getLogger(JwDepartmentAPI.class);
    private static String department_create_url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=ACCESS_TOKEN";
    private static String department_update_url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=ACCESS_TOKEN";
    private static String department_delete_url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=ACCESS_TOKEN&id=ID";
    private static String department_list_url_get = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=ACCESS_TOKEN&id=ID";
    private static String department_list_url = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=ACCESS_TOKEN";

    public static DepartMsgResponse createDepartment(Department department, String accessToken) {
        logger.info("[CREATEDEPARTMENT]", (Object)"createDepartment param:accessToken:{},menu:{}", (Object)new Object[]{accessToken, department});
        DepartMsgResponse res = null;
        String url = department_create_url.replace("ACCESS_TOKEN", accessToken);
        String jsonParam = JSONObject.toJSONString((Object)department);
        logger.info("[CREATEDEPARTMENT]", (Object)"createDepartment param:jsonParam:{}", (Object)new Object[]{jsonParam});
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonParam);
        logger.info("[CREATEDEPARTMENT]", (Object)"createDepartment response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            res = new DepartMsgResponse();
            int errcode = jsonObject.getIntValue("errcode");
            String errmsg = jsonObject.getString("errmsg");
            System.out.println("errcode\uff1a" + errcode + "\uff0cerrmsg:" + errmsg);
            res.setErrcode(errcode);
            res.setErrmsg(errmsg);
            if (errcode == 0) {
                int id = jsonObject.getIntValue("id");
                res.setId(id);
            }
        }
        return res;
    }

    public static List<Department> getAllDepartment(String accessToken) {
        logger.info("[CREATEDEPARTMENT]", (Object)"createDepartment param:accessToken:{},menu:{}", (Object)new Object[]{accessToken});
        Object res = null;
        String url = department_list_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = HttpUtil.sendPost(url);
        logger.info("[CREATEDEPARTMENT]", (Object)"createDepartment response:{}", (Object)new Object[]{jsonObject.toJSONString()});
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            String errmsg = jsonObject.getString("errmsg");
            String departmentjson = jsonObject.getString("department");
            List ps = JSON.parseArray((String)departmentjson, Department.class);
            return ps;
        }
        return null;
    }

    public static List<Department> getDepartmentById(String depId, String accessToken) {
        logger.info("[JW_DEPARTMENT] getDepartmentById param:accessToken:{}", new Object[]{accessToken});
        String url = department_list_url_get.replace("ACCESS_TOKEN", accessToken).replace("ID", depId);
        JSONObject response = HttpUtil.sendPost(url);
        logger.info("[JW_DEPARTMENT] getDepartmentById response:{}", new Object[]{response.toJSONString()});
        return response.getJSONArray("department").toJavaList(Department.class);
    }

    public static int deleteDepart(String departId, String accessToken) {
        String url = department_delete_url.replace("ACCESS_TOKEN", accessToken).replace("ID", departId);
        JSONObject jsonObject = HttpUtil.sendPost(url);
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            String errmsg = jsonObject.getString("errmsg");
            System.out.println("errcode\uff1a" + errcode + "\uff0cerrmsg:" + errmsg);
            return errcode;
        }
        return -1;
    }

    public static int updateDepart(Department department, String accessToken) {
        String jsonParam;
        String url = department_update_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = HttpUtil.sendPost(url, jsonParam = JSONObject.toJSONString((Object)department));
        if (null != jsonObject) {
            int errcode = jsonObject.getIntValue("errcode");
            String errmsg = jsonObject.getString("errmsg");
            System.out.println("errcode\uff1a" + errcode + "\uff0cerrmsg:" + errmsg);
            return errcode;
        }
        return -1;
    }

    public static void main(String[] args) {
        try {
            AccessToken accessToken = JwAccessTokenAPI.getAccessToken(JwParamesAPI.corpId, JwParamesAPI.secret);
            Department department = new Department();
            department.setId("cccddd");
            department.setName("cccddd");
            department.setOrder("2");
            department.setParentid("28A874914D2F4082AFCA1201E8B21E5B");
            JwDepartmentAPI.createDepartment(department, accessToken.getAccesstoken());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

