/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.pojo.Record;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class SwitchDomain
implements Record,
Cloneable {
    private static final long serialVersionUID = 7619505097145337232L;
    private List<String> masters;
    private Map<String, Integer> adWeightMap = new HashMap<String, Integer>();
    private long defaultPushCacheMillis = TimeUnit.SECONDS.toMillis(10L);
    private long clientBeatInterval = TimeUnit.SECONDS.toMillis(5L);
    private long defaultCacheMillis = TimeUnit.SECONDS.toMillis(3L);
    private float distroThreshold = 0.7f;
    private boolean healthCheckEnabled = true;
    private boolean autoChangeHealthCheckEnabled = true;
    private boolean distroEnabled = true;
    private boolean enableStandalone = true;
    private boolean pushEnabled = true;
    private int checkTimes = 3;
    private HttpHealthParams httpHealthParams = new HttpHealthParams();
    private TcpHealthParams tcpHealthParams = new TcpHealthParams();
    private MysqlHealthParams mysqlHealthParams = new MysqlHealthParams();
    private List<String> incrementalList = new ArrayList<String>();
    private long serverStatusSynchronizationPeriodMillis = TimeUnit.SECONDS.toMillis(2L);
    private long serviceStatusSynchronizationPeriodMillis = TimeUnit.SECONDS.toMillis(5L);
    private boolean disableAddIP = false;
    private boolean sendBeatOnly = false;
    private boolean lightBeatEnabled = true;
    private Map<String, Integer> limitedUrlMap = new HashMap<String, Integer>();
    private long distroServerExpiredMillis = TimeUnit.SECONDS.toMillis(10L);
    private String pushGoVersion = "0.1.0";
    private String pushJavaVersion = "0.1.0";
    private String pushPythonVersion = "0.4.3";
    private String pushCVersion = "1.0.12";
    private String pushCSharpVersion = "0.9.0";
    private boolean enableAuthentication = false;
    private String overriddenServerStatus = null;
    private boolean defaultInstanceEphemeral = true;
    private Set<String> healthCheckWhiteList = new HashSet<String>();

    public boolean isEnableAuthentication() {
        return this.enableAuthentication;
    }

    public void setEnableAuthentication(boolean enableAuthentication) {
        this.enableAuthentication = enableAuthentication;
    }

    public Set<String> getHealthCheckWhiteList() {
        return this.healthCheckWhiteList;
    }

    public void setHealthCheckWhiteList(Set<String> healthCheckWhiteList) {
        this.healthCheckWhiteList = healthCheckWhiteList;
    }

    public long getClientBeatInterval() {
        return this.clientBeatInterval;
    }

    public void setClientBeatInterval(long clientBeatInterval) {
        this.clientBeatInterval = clientBeatInterval;
    }

    public boolean isEnableStandalone() {
        return this.enableStandalone;
    }

    public void setEnableStandalone(boolean enableStandalone) {
        this.enableStandalone = enableStandalone;
    }

    public boolean isSendBeatOnly() {
        return this.sendBeatOnly;
    }

    public void setSendBeatOnly(boolean sendBeatOnly) {
        this.sendBeatOnly = sendBeatOnly;
    }

    public String getName() {
        return "00-00---000-NACOS_SWITCH_DOMAIN-000---00-00";
    }

    public void update(SwitchDomain domain) {
    }

    public List<String> getIncrementalList() {
        return this.incrementalList;
    }

    public void setIncrementalList(List<String> incrementalList) {
        this.incrementalList = incrementalList;
    }

    public List<String> getMasters() {
        return this.masters;
    }

    public void setMasters(List<String> masters) {
        this.masters = masters;
    }

    public Map<String, Integer> getAdWeightMap() {
        return this.adWeightMap;
    }

    public void setAdWeightMap(Map<String, Integer> adWeightMap) {
        this.adWeightMap = adWeightMap;
    }

    public Integer getAdWeight(String key) {
        return this.getAdWeightMap().get(key);
    }

    public long getDefaultPushCacheMillis() {
        return this.defaultPushCacheMillis;
    }

    public void setDefaultPushCacheMillis(long defaultPushCacheMillis) {
        this.defaultPushCacheMillis = defaultPushCacheMillis;
    }

    public long getDefaultCacheMillis() {
        return this.defaultCacheMillis;
    }

    public void setDefaultCacheMillis(long defaultCacheMillis) {
        this.defaultCacheMillis = defaultCacheMillis;
    }

    public float getDistroThreshold() {
        return this.distroThreshold;
    }

    public void setDistroThreshold(float distroThreshold) {
        this.distroThreshold = distroThreshold;
    }

    public long getPushCacheMillis(String serviceName) {
        return this.defaultPushCacheMillis;
    }

    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public boolean isHealthCheckEnabled(String serviceName) {
        return this.healthCheckEnabled || this.getHealthCheckWhiteList().contains(serviceName);
    }

    public void setHealthCheckEnabled(boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public boolean isAutoChangeHealthCheckEnabled() {
        return this.autoChangeHealthCheckEnabled;
    }

    public void setAutoChangeHealthCheckEnabled(boolean autoChangeHealthCheckEnabled) {
        this.autoChangeHealthCheckEnabled = autoChangeHealthCheckEnabled;
    }

    public boolean isDistroEnabled() {
        return this.distroEnabled;
    }

    public void setDistroEnabled(boolean distroEnabled) {
        this.distroEnabled = distroEnabled;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }

    public int getCheckTimes() {
        return this.checkTimes;
    }

    public void setCheckTimes(int checkTimes) {
        this.checkTimes = checkTimes;
    }

    public HttpHealthParams getHttpHealthParams() {
        return this.httpHealthParams;
    }

    public void setHttpHealthParams(HttpHealthParams httpHealthParams) {
        this.httpHealthParams = httpHealthParams;
    }

    public TcpHealthParams getTcpHealthParams() {
        return this.tcpHealthParams;
    }

    public void setTcpHealthParams(TcpHealthParams tcpHealthParams) {
        this.tcpHealthParams = tcpHealthParams;
    }

    public MysqlHealthParams getMysqlHealthParams() {
        return this.mysqlHealthParams;
    }

    public void setMysqlHealthParams(MysqlHealthParams mysqlHealthParams) {
        this.mysqlHealthParams = mysqlHealthParams;
    }

    public long getServerStatusSynchronizationPeriodMillis() {
        return this.serverStatusSynchronizationPeriodMillis;
    }

    public void setServerStatusSynchronizationPeriodMillis(long serverStatusSynchronizationPeriodMillis) {
        this.serverStatusSynchronizationPeriodMillis = serverStatusSynchronizationPeriodMillis;
    }

    public long getServiceStatusSynchronizationPeriodMillis() {
        return this.serviceStatusSynchronizationPeriodMillis;
    }

    public void setServiceStatusSynchronizationPeriodMillis(long serviceStatusSynchronizationPeriodMillis) {
        this.serviceStatusSynchronizationPeriodMillis = serviceStatusSynchronizationPeriodMillis;
    }

    public boolean isDisableAddIP() {
        return this.disableAddIP;
    }

    public void setDisableAddIP(boolean disableAddIP) {
        this.disableAddIP = disableAddIP;
    }

    public Map<String, Integer> getLimitedUrlMap() {
        return this.limitedUrlMap;
    }

    public void setLimitedUrlMap(Map<String, Integer> limitedUrlMap) {
        this.limitedUrlMap = limitedUrlMap;
    }

    public long getDistroServerExpiredMillis() {
        return this.distroServerExpiredMillis;
    }

    public void setDistroServerExpiredMillis(long distroServerExpiredMillis) {
        this.distroServerExpiredMillis = distroServerExpiredMillis;
    }

    public String getPushGoVersion() {
        return this.pushGoVersion;
    }

    public void setPushGoVersion(String pushGoVersion) {
        this.pushGoVersion = pushGoVersion;
    }

    public String getPushCSharpVersion() {
        return this.pushCSharpVersion;
    }

    public void setPushCSharpVersion(String pushCSharpVersion) {
        this.pushCSharpVersion = pushCSharpVersion;
    }

    public String getPushJavaVersion() {
        return this.pushJavaVersion;
    }

    public void setPushJavaVersion(String pushJavaVersion) {
        this.pushJavaVersion = pushJavaVersion;
    }

    public String getPushPythonVersion() {
        return this.pushPythonVersion;
    }

    public void setPushPythonVersion(String pushPythonVersion) {
        this.pushPythonVersion = pushPythonVersion;
    }

    public String getPushCVersion() {
        return this.pushCVersion;
    }

    public void setPushCVersion(String pushCVersion) {
        this.pushCVersion = pushCVersion;
    }

    public String getOverriddenServerStatus() {
        return this.overriddenServerStatus;
    }

    public void setOverriddenServerStatus(String overriddenServerStatus) {
        this.overriddenServerStatus = overriddenServerStatus;
    }

    public boolean isDefaultInstanceEphemeral() {
        return this.defaultInstanceEphemeral;
    }

    public void setDefaultInstanceEphemeral(boolean defaultInstanceEphemeral) {
        this.defaultInstanceEphemeral = defaultInstanceEphemeral;
    }

    public boolean isLightBeatEnabled() {
        return this.lightBeatEnabled;
    }

    public void setLightBeatEnabled(boolean lightBeatEnabled) {
        this.lightBeatEnabled = lightBeatEnabled;
    }

    public String toString() {
        return JacksonUtils.toJson((Object)this);
    }

    protected SwitchDomain clone() throws CloneNotSupportedException {
        return (SwitchDomain)super.clone();
    }

    @Override
    public String getChecksum() {
        return null;
    }

    public static class TcpHealthParams
    implements HealthParams {
        private int max = 5000;
        private int min = 1000;
        private float factor = 0.75f;

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public float getFactor() {
            return this.factor;
        }

        public void setFactor(float factor) {
            this.factor = factor;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void setMin(int min) {
            this.min = min;
        }
    }

    public static class MysqlHealthParams
    implements HealthParams {
        private int max = 3000;
        private int min = 2000;
        private float factor = 0.65f;

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public float getFactor() {
            return this.factor;
        }

        public void setFactor(float factor) {
            this.factor = factor;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void setMin(int min) {
            this.min = min;
        }
    }

    public static class HttpHealthParams
    implements HealthParams {
        public static final int MIN_MAX = 3000;
        public static final int MIN_MIN = 500;
        private int max = 5000;
        private int min = 500;
        private float factor = 0.85f;

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public float getFactor() {
            return this.factor;
        }

        public void setFactor(float factor) {
            this.factor = factor;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void setMin(int min) {
            this.min = min;
        }
    }

    public static interface HealthParams {
        public int getMax();

        public int getMin();

        public float getFactor();
    }
}

