/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.common.utils.RandomUtils;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.healthcheck.NacosHealthCheckTask;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2Delegate;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Optional;

public class HealthCheckTaskV2
extends AbstractExecuteTask
implements NacosHealthCheckTask {
    private static final int LOWER_CHECK_RT = 2000;
    private static final int UPPER_RANDOM_CHECK_RT = 5000;
    private static SwitchDomain switchDomain;
    private static NamingMetadataManager metadataManager;
    private final IpPortBasedClient client;
    private final String taskId;
    private long checkRtNormalized = -1L;
    private long checkRtBest = -1L;
    private long checkRtWorst = -1L;
    private long checkRtLast = -1L;
    private long checkRtLastLast = -1L;
    private long startTime;
    private volatile boolean cancelled = false;

    public HealthCheckTaskV2(IpPortBasedClient client) {
        this.client = client;
        this.taskId = client.getResponsibleId();
    }

    private void initIfNecessary() {
        if (switchDomain == null) {
            switchDomain = (SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class);
        }
        if (metadataManager == null) {
            metadataManager = (NamingMetadataManager)((Object)ApplicationUtils.getBean(NamingMetadataManager.class));
        }
        this.initCheckRT();
    }

    private void initCheckRT() {
        if (-1L != this.checkRtNormalized) {
            return;
        }
        this.checkRtNormalized = null != switchDomain ? (long)(2000 + RandomUtils.nextInt((int)0, (int)RandomUtils.nextInt((int)0, (int)switchDomain.getTcpHealthParams().getMax()))) : (long)(2000 + RandomUtils.nextInt((int)0, (int)5000));
        this.checkRtBest = Long.MAX_VALUE;
        this.checkRtWorst = 0L;
    }

    public IpPortBasedClient getClient() {
        return this.client;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doHealthCheck() {
        try {
            this.initIfNecessary();
            for (Service each : this.client.getAllPublishedService()) {
                if (!switchDomain.isHealthCheckEnabled(each.getGroupedServiceName())) continue;
                InstancePublishInfo instancePublishInfo = this.client.getInstancePublishInfo(each);
                ClusterMetadata metadata = this.getClusterMetadata(each, instancePublishInfo);
                ((HealthCheckProcessorV2Delegate)ApplicationUtils.getBean(HealthCheckProcessorV2Delegate.class)).process(this, each, metadata);
                if (!Loggers.EVT_LOG.isDebugEnabled()) continue;
                Loggers.EVT_LOG.debug("[HEALTH-CHECK] schedule health check task: {}", (Object)this.client.getClientId());
            }
            if (this.cancelled) return;
            this.initCheckRT();
        }
        catch (Throwable e) {
            try {
                Loggers.SRV_LOG.error("[HEALTH-CHECK] error while process health check for {}", (Object)this.client.getClientId(), (Object)e);
                if (this.cancelled) return;
                this.initCheckRT();
            }
            catch (Throwable throwable) {
                if (this.cancelled) throw throwable;
                this.initCheckRT();
                HealthCheckReactor.scheduleCheck(this);
                if (this.getCheckRtWorst() <= 0L) throw throwable;
                long checkRtLastLast = this.getCheckRtLastLast();
                this.setCheckRtLastLast(this.getCheckRtLast());
                if (checkRtLastLast <= 0L) throw throwable;
                long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / checkRtLastLast;
                if (!Loggers.CHECK_RT.isDebugEnabled()) throw throwable;
                Loggers.CHECK_RT.debug("{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{this.client.getClientId(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
                throw throwable;
            }
            HealthCheckReactor.scheduleCheck(this);
            if (this.getCheckRtWorst() <= 0L) return;
            long checkRtLastLast = this.getCheckRtLastLast();
            this.setCheckRtLastLast(this.getCheckRtLast());
            if (checkRtLastLast <= 0L) return;
            long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / checkRtLastLast;
            if (!Loggers.CHECK_RT.isDebugEnabled()) return;
            Loggers.CHECK_RT.debug("{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{this.client.getClientId(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
            return;
        }
        HealthCheckReactor.scheduleCheck(this);
        if (this.getCheckRtWorst() <= 0L) return;
        long checkRtLastLast = this.getCheckRtLastLast();
        this.setCheckRtLastLast(this.getCheckRtLast());
        if (checkRtLastLast <= 0L) return;
        long diff = (this.getCheckRtLast() - this.getCheckRtLastLast()) * 10000L / checkRtLastLast;
        if (!Loggers.CHECK_RT.isDebugEnabled()) return;
        Loggers.CHECK_RT.debug("{}->normalized: {}, worst: {}, best: {}, last: {}, diff: {}", new Object[]{this.client.getClientId(), this.getCheckRtNormalized(), this.getCheckRtWorst(), this.getCheckRtBest(), this.getCheckRtLast(), diff});
        return;
    }

    @Override
    public void passIntercept() {
        this.doHealthCheck();
    }

    @Override
    public void afterIntercept() {
        if (!this.cancelled) {
            try {
                this.initIfNecessary();
            }
            finally {
                this.initCheckRT();
                HealthCheckReactor.scheduleCheck(this);
            }
        }
    }

    @Override
    public void run() {
        this.doHealthCheck();
    }

    private ClusterMetadata getClusterMetadata(Service service, InstancePublishInfo instancePublishInfo) {
        Optional<ServiceMetadata> serviceMetadata = metadataManager.getServiceMetadata(service);
        if (!serviceMetadata.isPresent()) {
            return new ClusterMetadata();
        }
        String cluster = instancePublishInfo.getCluster();
        ClusterMetadata result = serviceMetadata.get().getClusters().get(cluster);
        return null == result ? new ClusterMetadata() : result;
    }

    public long getCheckRtNormalized() {
        return this.checkRtNormalized;
    }

    public long getCheckRtBest() {
        return this.checkRtBest;
    }

    public long getCheckRtWorst() {
        return this.checkRtWorst;
    }

    public void setCheckRtWorst(long checkRtWorst) {
        this.checkRtWorst = checkRtWorst;
    }

    public void setCheckRtBest(long checkRtBest) {
        this.checkRtBest = checkRtBest;
    }

    public void setCheckRtNormalized(long checkRtNormalized) {
        this.checkRtNormalized = checkRtNormalized;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getCheckRtLast() {
        return this.checkRtLast;
    }

    public void setCheckRtLast(long checkRtLast) {
        this.checkRtLast = checkRtLast;
    }

    public long getCheckRtLastLast() {
        return this.checkRtLastLast;
    }

    public void setCheckRtLastLast(long checkRtLastLast) {
        this.checkRtLastLast = checkRtLastLast;
    }
}

