/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.service.impl;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.ClassUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.naming.consistency.persistent.impl.AbstractSnapshotOperation;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncData;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.PersistentIpPortClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationService;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.Checksum;
import org.springframework.stereotype.Component;

@Component(value="persistentClientOperationServiceImpl")
public class PersistentClientOperationServiceImpl
extends RequestProcessor4CP
implements ClientOperationService {
    private final PersistentIpPortClientManager clientManager;
    private final Serializer serializer = SerializeFactory.getDefault();
    private final CPProtocol protocol;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private static final int INITIAL_CAPACITY = 128;

    public PersistentClientOperationServiceImpl(PersistentIpPortClientManager clientManager) {
        this.clientManager = clientManager;
        this.protocol = ((ProtocolManager)ApplicationUtils.getBean(ProtocolManager.class)).getCpProtocol();
        this.protocol.addRequestProcessors(Collections.singletonList(this));
    }

    @Override
    public void registerInstance(Service service, Instance instance, String clientId) {
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        if (singleton.isEphemeral()) {
            throw new NacosRuntimeException(400, String.format("Current service %s is ephemeral service, can't register persistent instance.", singleton.getGroupedServiceName()));
        }
        InstanceStoreRequest request = new InstanceStoreRequest();
        request.setService(service);
        request.setInstance(instance);
        request.setClientId(clientId);
        WriteRequest writeRequest = WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)request))).setOperation(DataOperation.ADD.name()).build();
        try {
            this.protocol.write(writeRequest);
            Loggers.RAFT.info("Client registered. service={}, clientId={}, instance={}", new Object[]{service, clientId, instance});
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    public void updateInstance(Service service, Instance instance, String clientId) {
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        if (singleton.isEphemeral()) {
            throw new NacosRuntimeException(400, String.format("Current service %s is ephemeral service, can't update persistent instance.", singleton.getGroupedServiceName()));
        }
        InstanceStoreRequest request = new InstanceStoreRequest();
        request.setService(service);
        request.setInstance(instance);
        request.setClientId(clientId);
        WriteRequest writeRequest = WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)request))).setOperation(DataOperation.CHANGE.name()).build();
        try {
            this.protocol.write(writeRequest);
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    @Override
    public void batchRegisterInstance(Service service, List<Instance> instances, String clientId) {
    }

    @Override
    public void deregisterInstance(Service service, Instance instance, String clientId) {
        InstanceStoreRequest request = new InstanceStoreRequest();
        request.setService(service);
        request.setInstance(instance);
        request.setClientId(clientId);
        WriteRequest writeRequest = WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)request))).setOperation(DataOperation.DELETE.name()).build();
        try {
            this.protocol.write(writeRequest);
            Loggers.RAFT.info("Client unregistered. service={}, clientId={}, instance={}", new Object[]{service, clientId, instance});
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    @Override
    public void subscribeService(Service service, Subscriber subscriber, String clientId) {
        throw new UnsupportedOperationException("No persistent subscribers");
    }

    @Override
    public void unsubscribeService(Service service, Subscriber subscriber, String clientId) {
        throw new UnsupportedOperationException("No persistent subscribers");
    }

    public Response onRequest(ReadRequest request) {
        throw new UnsupportedOperationException("Temporary does not support");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest request) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        lock.lock();
        try {
            InstanceStoreRequest instanceRequest = (InstanceStoreRequest)this.serializer.deserialize(request.getData().toByteArray());
            DataOperation operation = DataOperation.valueOf((String)request.getOperation());
            switch (operation) {
                case ADD: {
                    this.onInstanceRegister(instanceRequest.service, instanceRequest.instance, instanceRequest.getClientId());
                    break;
                }
                case DELETE: {
                    this.onInstanceDeregister(instanceRequest.service, instanceRequest.getClientId());
                    break;
                }
                case CHANGE: {
                    if (!this.instanceAndServiceExist(instanceRequest)) break;
                    this.onInstanceRegister(instanceRequest.service, instanceRequest.instance, instanceRequest.getClientId());
                    break;
                }
                default: {
                    Response response = Response.newBuilder().setSuccess(false).setErrMsg("unsupport operation : " + operation).build();
                    return response;
                }
            }
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            Loggers.RAFT.warn("Persistent client operation failed. ", (Throwable)e);
            Response response = Response.newBuilder().setSuccess(false).setErrMsg("Persistent client operation failed. " + e.getMessage()).build();
            return response;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean instanceAndServiceExist(InstanceStoreRequest instanceRequest) {
        return this.clientManager.contains(instanceRequest.getClientId()) && this.clientManager.getClient(instanceRequest.getClientId()).getAllPublishedService().contains(instanceRequest.service);
    }

    private void onInstanceRegister(Service service, Instance instance, String clientId) {
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        if (!this.clientManager.contains(clientId)) {
            this.clientManager.clientConnected(clientId, new ClientAttributes());
        }
        Client client = this.clientManager.getClient(clientId);
        InstancePublishInfo instancePublishInfo = this.getPublishInfo(instance);
        client.addServiceInstance(singleton, instancePublishInfo);
        client.setLastUpdatedTime();
        NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientRegisterServiceEvent(singleton, clientId));
    }

    private void onInstanceDeregister(Service service, String clientId) {
        Service singleton = ServiceManager.getInstance().getSingleton(service);
        Client client = this.clientManager.getClient(clientId);
        if (client == null) {
            Loggers.RAFT.warn("client not exist onInstanceDeregister, clientId : {} ", (Object)clientId);
            return;
        }
        client.removeServiceInstance(singleton);
        client.setLastUpdatedTime();
        if (client.getAllPublishedService().isEmpty()) {
            this.clientManager.clientDisconnected(clientId);
        }
        NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientDeregisterServiceEvent(singleton, clientId));
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(new PersistentInstanceSnapshotOperation(this.lock));
    }

    public String group() {
        return "naming_persistent_service_v2";
    }

    private class PersistentInstanceSnapshotOperation
    extends AbstractSnapshotOperation {
        private final String snapshotSaveTag;
        private final String snapshotLoadTag;
        private static final String SNAPSHOT_ARCHIVE = "persistent_instance.zip";

        public PersistentInstanceSnapshotOperation(ReentrantReadWriteLock lock) {
            super(lock);
            this.snapshotSaveTag = ClassUtils.getSimpleName(this.getClass()) + ".SAVE";
            this.snapshotLoadTag = ClassUtils.getSimpleName(this.getClass()) + ".LOAD";
        }

        @Override
        protected boolean writeSnapshot(Writer writer) throws IOException {
            String writePath = writer.getPath();
            String outputFile = Paths.get(writePath, SNAPSHOT_ARCHIVE).toString();
            CRC64 checksum = new CRC64();
            try (InputStream inputStream = this.dumpSnapshot();){
                DiskUtils.compressIntoZipFile((String)"instance", (InputStream)inputStream, (String)outputFile, (Checksum)checksum);
            }
            LocalFileMeta meta = new LocalFileMeta();
            meta.append((Object)"checksum", (Object)Long.toHexString(checksum.getValue()));
            return writer.addFile(SNAPSHOT_ARCHIVE, meta);
        }

        @Override
        protected boolean readSnapshot(Reader reader) throws Exception {
            String readerPath = reader.getPath();
            Loggers.RAFT.info("snapshot start to load from : {}", (Object)readerPath);
            String sourceFile = Paths.get(readerPath, SNAPSHOT_ARCHIVE).toString();
            CRC64 checksum = new CRC64();
            byte[] snapshotBytes = DiskUtils.decompress((String)sourceFile, (Checksum)checksum);
            LocalFileMeta fileMeta = reader.getFileMeta(SNAPSHOT_ARCHIVE);
            if (fileMeta.getFileMeta().containsKey("checksum") && !Objects.equals(Long.toHexString(checksum.getValue()), fileMeta.get("checksum"))) {
                throw new IllegalArgumentException("Snapshot checksum failed");
            }
            this.loadSnapshot(snapshotBytes);
            Loggers.RAFT.info("snapshot success to load from : {}", (Object)readerPath);
            return true;
        }

        protected InputStream dumpSnapshot() {
            Map<String, IpPortBasedClient> clientMap = PersistentClientOperationServiceImpl.this.clientManager.showClients();
            ConcurrentHashMap clone = new ConcurrentHashMap(128);
            clientMap.forEach((clientId, client) -> clone.put(clientId, client.generateSyncData()));
            return new ByteArrayInputStream(PersistentClientOperationServiceImpl.this.serializer.serialize(clone));
        }

        protected void loadSnapshot(byte[] snapshotBytes) {
            ConcurrentHashMap newData = (ConcurrentHashMap)PersistentClientOperationServiceImpl.this.serializer.deserialize(snapshotBytes);
            Collection<String> oldClientIds = PersistentClientOperationServiceImpl.this.clientManager.allClientId();
            for (Map.Entry<String, ClientSyncData> entry : newData.entrySet()) {
                if (oldClientIds.contains(entry.getKey())) {
                    this.updateSyncDataToClient(entry, (IpPortBasedClient)PersistentClientOperationServiceImpl.this.clientManager.getClient((String)entry.getKey()));
                    continue;
                }
                IpPortBasedClient snapshotClient = new IpPortBasedClient((String)entry.getKey(), false);
                snapshotClient.setAttributes(entry.getValue().getAttributes());
                snapshotClient.init();
                this.addSyncDataToClient(entry, snapshotClient);
            }
            this.removeDeadClient(newData.keySet(), oldClientIds);
        }

        private void updateSyncDataToClient(Map.Entry<String, ClientSyncData> entry, IpPortBasedClient client) {
            ClientSyncData data = entry.getValue();
            List<String> namespaces = data.getNamespaces();
            List<String> groupNames = data.getGroupNames();
            List<String> serviceNames = data.getServiceNames();
            List<InstancePublishInfo> instances = data.getInstancePublishInfos();
            HashMap<Service, InstancePublishInfo> newInstanceInfoMap = new HashMap<Service, InstancePublishInfo>(instances.size());
            for (int i = 0; i < namespaces.size(); ++i) {
                Service service = Service.newService(namespaces.get(i), groupNames.get(i), serviceNames.get(i), false);
                newInstanceInfoMap.put(service, instances.get(i));
            }
            Collection<Service> oldPublishedService = client.getAllPublishedService();
            Set aliveInstanceServices = newInstanceInfoMap.keySet();
            for (Service service : aliveInstanceServices) {
                Service singleton = ServiceManager.getInstance().getSingleton(service);
                InstancePublishInfo newInstanceInfo = (InstancePublishInfo)newInstanceInfoMap.get(singleton);
                if (oldPublishedService.contains(singleton)) {
                    InstancePublishInfo oldInstanceInfo = client.getInstancePublishInfo(singleton);
                    if (oldInstanceInfo == null || newInstanceInfo.equals(oldInstanceInfo)) continue;
                    client.putServiceInstance(singleton, newInstanceInfo);
                    NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientRegisterServiceEvent(singleton, client.getClientId()));
                    Loggers.RAFT.info("[SNAPSHOT-DATA-UPDATE] service={}, instance={}", (Object)service, (Object)newInstanceInfo);
                    continue;
                }
                client.putServiceInstance(singleton, newInstanceInfo);
                NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientRegisterServiceEvent(singleton, client.getClientId()));
                Loggers.RAFT.info("[SNAPSHOT-DATA-ADD] service={}, instance={}", (Object)service, (Object)newInstanceInfo);
            }
            for (Service service : oldPublishedService) {
                if (aliveInstanceServices.contains(service)) continue;
                InstancePublishInfo oldInfo = client.getInstancePublishInfo(service);
                client.removeServiceInstance(service);
                NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientDeregisterServiceEvent(service, client.getClientId()));
                Loggers.RAFT.info("[SNAPSHOT-DATA-REMOVE] service={}, instance={}", (Object)service, (Object)oldInfo);
            }
        }

        private void removeDeadClient(Collection<String> aliveClientIds, Collection<String> oldClientIds) {
            if (CollectionUtils.isEmpty(oldClientIds)) {
                return;
            }
            for (String oldClientId : oldClientIds) {
                Client client;
                if (aliveClientIds.contains(oldClientId) || (client = PersistentClientOperationServiceImpl.this.clientManager.getClient(oldClientId)) == null) continue;
                if (CollectionUtils.isNotEmpty(client.getAllPublishedService())) {
                    for (Service service : client.getAllPublishedService()) {
                        Service singleton = ServiceManager.getInstance().getSingleton(service);
                        InstancePublishInfo oldInfo = client.getInstancePublishInfo(service);
                        client.removeServiceInstance(service);
                        NotifyCenter.publishEvent((Event)new ClientOperationEvent.ClientDeregisterServiceEvent(singleton, client.getClientId()));
                        Loggers.RAFT.info("[SNAPSHOT-DATA-REMOVE] service={}, instance={}", (Object)singleton, (Object)oldInfo);
                    }
                }
                PersistentClientOperationServiceImpl.this.clientManager.removeAndRelease(client.getClientId());
                Loggers.RAFT.info("[SNAPSHOT-DATA-REMOVE] client={}", (Object)client);
            }
        }

        private void addSyncDataToClient(Map.Entry<String, ClientSyncData> entry, IpPortBasedClient client) {
            ClientSyncData data = entry.getValue();
            List<String> namespaces = data.getNamespaces();
            List<String> groupNames = data.getGroupNames();
            List<String> serviceNames = data.getServiceNames();
            List<InstancePublishInfo> instances = data.getInstancePublishInfos();
            ArrayList<ClientOperationEvent.ClientRegisterServiceEvent> waitPublishEvents = new ArrayList<ClientOperationEvent.ClientRegisterServiceEvent>();
            for (int i = 0; i < namespaces.size(); ++i) {
                Service service = Service.newService(namespaces.get(i), groupNames.get(i), serviceNames.get(i), false);
                Service singleton = ServiceManager.getInstance().getSingleton(service);
                client.putServiceInstance(singleton, instances.get(i));
                Loggers.RAFT.info("[SNAPSHOT-DATA-ADD] service={}, instance={}", (Object)service, (Object)instances.get(i));
                waitPublishEvents.add(new ClientOperationEvent.ClientRegisterServiceEvent(singleton, client.getClientId()));
            }
            PersistentClientOperationServiceImpl.this.clientManager.addSyncClient(client);
            for (ClientOperationEvent.ClientRegisterServiceEvent waitPublishEvent : waitPublishEvents) {
                NotifyCenter.publishEvent((Event)waitPublishEvent);
            }
        }

        @Override
        protected String getSnapshotSaveTag() {
            return this.snapshotSaveTag;
        }

        @Override
        protected String getSnapshotLoadTag() {
            return this.snapshotLoadTag;
        }
    }

    protected static class InstanceStoreRequest
    implements Serializable {
        private static final long serialVersionUID = -9077205657156890549L;
        private Service service;
        private Instance instance;
        private String clientId;

        protected InstanceStoreRequest() {
        }

        public Service getService() {
            return this.service;
        }

        public void setService(Service service) {
            this.service = service;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public void setInstance(Instance instance) {
            this.instance = instance;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }
}

