/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.model.ConfigMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class YamlParserUtil {
    public static String dumpObject(Object object) {
        return new Yaml((BaseConstructor)new YamlParserConstructor(), (Representer)new CustomRepresenter()).dumpAsMap(object);
    }

    public static <T> T loadObject(String content, Class<T> type) {
        return (T)new Yaml((BaseConstructor)new YamlParserConstructor(), (Representer)new CustomRepresenter()).loadAs(content, type);
    }

    public static class ConstructYamlConfigMetadata
    extends AbstractConstruct {
        public Object construct(Node node) {
            if (!YamlParserConstructor.configMetadataTag.getValue().equals(node.getTag().getValue())) {
                throw new NacosRuntimeException(400, "could not determine a constructor for the tag " + node.getTag() + node.getStartMark());
            }
            MappingNode mNode = (MappingNode)node;
            List value = mNode.getValue();
            if (CollectionUtils.isEmpty((Collection)value)) {
                return null;
            }
            NodeTuple nodeTuple = (NodeTuple)value.get(0);
            ConfigMetadata configMetadata = new ConfigMetadata();
            SequenceNode sequenceNode = (SequenceNode)nodeTuple.getValueNode();
            if (CollectionUtils.isEmpty((Collection)sequenceNode.getValue())) {
                return configMetadata;
            }
            List<ConfigMetadata.ConfigExportItem> exportItems = sequenceNode.getValue().stream().map(itemValue -> {
                ConfigMetadata.ConfigExportItem configExportItem = new ConfigMetadata.ConfigExportItem();
                MappingNode itemMap = (MappingNode)itemValue;
                List propertyValues = itemMap.getValue();
                HashMap metadataMap = new HashMap(propertyValues.size());
                propertyValues.forEach(metadata -> {
                    ScalarNode keyNode = (ScalarNode)metadata.getKeyNode();
                    ScalarNode valueNode = (ScalarNode)metadata.getValueNode();
                    metadataMap.put(keyNode.getValue(), valueNode.getValue());
                });
                configExportItem.setDataId((String)metadataMap.get("dataId"));
                configExportItem.setGroup((String)metadataMap.get("group"));
                configExportItem.setType((String)metadataMap.get("type"));
                configExportItem.setDesc((String)metadataMap.get("desc"));
                configExportItem.setAppName((String)metadataMap.get("appName"));
                return configExportItem;
            }).collect(Collectors.toList());
            configMetadata.setMetadata(exportItems);
            return configMetadata;
        }
    }

    public static class CustomRepresenter
    extends Representer {
        public CustomRepresenter() {
            super(new DumperOptions());
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }
    }

    public static class YamlParserConstructor
    extends SafeConstructor {
        public static Tag configMetadataTag = new Tag(ConfigMetadata.class);

        public YamlParserConstructor() {
            super(new LoaderOptions());
            this.yamlConstructors.put(configMetadataTag, new ConstructYamlConfigMetadata());
        }
    }
}

