/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBetaWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoBetaMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoBetaPersistServiceImpl")
public class EmbeddedConfigInfoBetaPersistServiceImpl
implements ConfigInfoBetaPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedConfigInfoBetaPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4BetaState(String dataId, String group, String tenant) {
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String sql = configInfoBetaMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return (ConfigInfoStateWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
    }

    private ConfigOperateResult getBetaOperateResult(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoStateWrapper configInfo4Beta = this.findConfigInfo4BetaState(dataId, group, tenantTmp);
        if (configInfo4Beta == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Beta.getId(), configInfo4Beta.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult addConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String sql = configInfoBetaMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "app_name", "content", "md5", "beta_ips", "src_ip", "src_user", "gmt_create", "gmt_modified", "encrypted_data_key"));
            Object[] args = new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, time, encryptedDataKey};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdateBeta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        if (this.findConfigInfo4BetaState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            return this.addConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
        }
        return this.updateConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateBetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        if (this.findConfigInfo4BetaState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()) == null) {
            return this.addConfigInfo4Beta(configInfo, betaIps, srcIp, srcUser);
        }
        return this.updateConfigInfo4BetaCas(configInfo, betaIps, srcIp, srcUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoStateWrapper configInfo = this.findConfigInfo4BetaState(dataId, group, tenant);
        if (configInfo != null) {
            try {
                ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
                String sql = configInfoBetaMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id"));
                Object[] args = new Object[]{dataId, group, tenantTmp};
                EmbeddedStorageContextUtils.onDeleteConfigBetaInfo(tenantTmp, group, dataId, System.currentTimeMillis());
                EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("[Tag] Configuration deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextHolder.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4Beta(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String encryptedDataKey = StringUtils.defaultEmptyIfBlank((String)configInfo.getEncryptedDataKey());
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String sql = configInfoBetaMapper.update(Arrays.asList("content", "md5", "beta_ips", "src_ip", "src_user", "gmt_modified", "app_name", "encrypted_data_key"), Arrays.asList("data_id", "group_id", "tenant_id"));
            Object[] args = new Object[]{configInfo.getContent(), md5, betaIps, srcIp, srcUser, time, appNameTmp, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4BetaCas(ConfigInfo configInfo, String betaIps, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5);
            context.putUpdateParameter("betaIps", (Object)betaIps);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("gmtModified", (Object)time);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoBetaMapper.updateConfigInfo4BetaCas(context);
            String sql = mapperResult.getSql();
            List paramList = mapperResult.getParamList();
            Object[] args = paramList.toArray();
            EmbeddedStorageContextUtils.onModifyConfigBetaInfo(configInfo, betaIps, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            boolean success = this.databaseOperate.blockUpdate();
            if (success) {
                ConfigOperateResult configOperateResult = this.getBetaOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
                return configOperateResult;
            }
            ConfigOperateResult configOperateResult = new ConfigOperateResult(false);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigInfoBetaWrapper findConfigInfo4Beta(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "beta_ips", "encrypted_data_key", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return (ConfigInfoBetaWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }

    @Override
    public int configInfoBetaCount() {
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sql = configInfoBetaMapper.count(null);
        Integer result = (Integer)this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoBetaWrapper> findAllConfigInfoBetaForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoBetaMapper configInfoBetaMapper = (ConfigInfoBetaMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_beta");
        String sqlCountRows = configInfoBetaMapper.count(null);
        MapperContext context = new MapperContext();
        context.setStartRow(startRow);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configInfoBetaMapper.findAllConfigInfoBetaForDumpAllFetchRows(context);
        String sqlFetchRows = mapperResult.getSql();
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_BETA_WRAPPER_ROW_MAPPER);
    }
}

