/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.exception;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.persistence.monitor.DatasourceMetrics;
import java.io.IOException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handleIllegalArgumentException(Exception ex) throws IOException {
        MetricsMonitor.getIllegalArgumentException().increment();
        return ResponseEntity.status((int)400).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
    }

    @ExceptionHandler(value={NacosRuntimeException.class})
    public ResponseEntity<String> handleNacosRunTimeException(NacosRuntimeException ex) throws IOException {
        MetricsMonitor.getNacosException().increment();
        return ResponseEntity.status((int)ex.getErrCode()).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
    }

    @ExceptionHandler(value={NacosException.class})
    public ResponseEntity<String> handleNacosException(NacosException ex) throws IOException {
        MetricsMonitor.getNacosException().increment();
        return ResponseEntity.status((int)ex.getErrCode()).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
    }

    @ExceptionHandler(value={DataAccessException.class})
    public ResponseEntity<String> handleDataAccessException(DataAccessException ex) throws DataAccessException {
        DatasourceMetrics.getDbException().increment();
        return ResponseEntity.status((int)500).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
    }
}

