/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.core.cluster.MemberLookup;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/health"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class HealthController {
    private DataSourceService dataSourceService;
    private static final String HEALTH_UP = "UP";
    private static final String HEALTH_DOWN = "DOWN";
    private static final String HEALTH_WARN = "WARN";
    private final ServerMemberManager memberManager;

    public HealthController(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @PostConstruct
    public void init() {
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
    }

    @GetMapping
    public String getHealth() {
        StringBuilder sb = new StringBuilder();
        String dbStatus = this.dataSourceService.getHealth();
        boolean addressServerHealthy = this.isAddressServerHealthy();
        if (dbStatus.contains(HEALTH_UP) && addressServerHealthy && ServerMemberManager.isInIpList()) {
            sb.append(HEALTH_UP);
        } else if (dbStatus.contains(HEALTH_WARN) && addressServerHealthy && ServerMemberManager.isInIpList()) {
            sb.append("WARN:");
            sb.append("slave db (").append(dbStatus.split(":")[1]).append(") down. ");
        } else {
            sb.append("DOWN:");
            if (dbStatus.contains(HEALTH_DOWN)) {
                sb.append("master db (").append(dbStatus.split(":")[1]).append(") down. ");
            }
            if (!addressServerHealthy) {
                sb.append("address server down. ");
            }
            if (!ServerMemberManager.isInIpList()) {
                sb.append("server ip ").append(InetUtils.getSelfIP()).append(" is not in the serverList of address server. ");
            }
        }
        return sb.toString();
    }

    private boolean isAddressServerHealthy() {
        MemberLookup lookup = this.memberManager.getLookup();
        if (lookup == null) {
            return false;
        }
        boolean useAddressServer = lookup.useAddressServer();
        if (!useAddressServer) {
            return true;
        }
        Map info = lookup.info();
        if (info == null) {
            return false;
        }
        Object addressServerHealth = info.get("addressServerHealth");
        if (addressServerHealth == null) {
            return false;
        }
        return Boolean.parseBoolean(addressServerHealth.toString());
    }
}

