/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

class EmbeddedPaginationHelperImpl<E>
implements PaginationHelper {
    private final DatabaseOperate databaseOperate;

    public EmbeddedPaginationHelperImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPage(sqlCountRows, sqlFetchRows, args, pageNo, pageSize, (Long)null, rowMapper);
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, args, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        List result = this.databaseOperate.queryMany(sqlFetchRows, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        List result = this.databaseOperate.queryMany(sqlFetchRows, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, args1, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        List result = this.databaseOperate.queryMany(sqlFetchRows, args2, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Page page = new Page();
        List result = this.databaseOperate.queryMany(sqlFetchRows, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public void updateLimit(String sql, Object[] args) {
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }
}

