/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.processor;

import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;

public class DumpAllProcessor
implements NacosTaskProcessor {
    static final int PAGE_SIZE = 1000;
    final DumpService dumpService;
    final ConfigInfoPersistService configInfoPersistService;

    public DumpAllProcessor(DumpService dumpService) {
        this.dumpService = dumpService;
        this.configInfoPersistService = dumpService.getConfigInfoPersistService();
    }

    public boolean process(NacosTask task) {
        long currentMaxId = this.configInfoPersistService.findConfigMaxId();
        long lastMaxId = 0L;
        while (lastMaxId < currentMaxId) {
            Page<ConfigInfoWrapper> page = this.configInfoPersistService.findAllConfigInfoFragment(lastMaxId, 1000);
            if (page != null && page.getPageItems() != null && !page.getPageItems().isEmpty()) {
                for (ConfigInfoWrapper cf : page.getPageItems()) {
                    long id = cf.getId();
                    lastMaxId = Math.max(id, lastMaxId);
                    if (cf.getDataId().equals("com.alibaba.nacos.metadata.aggrIDs")) {
                        AggrWhitelist.load(cf.getContent());
                    }
                    if (cf.getDataId().equals("com.alibaba.nacos.metadata.clientIpWhitelist")) {
                        ClientIpWhiteList.load(cf.getContent());
                    }
                    if (cf.getDataId().equals("com.alibaba.nacos.meta.switch")) {
                        SwitchService.load(cf.getContent());
                    }
                    ConfigCacheService.dump(cf.getDataId(), cf.getGroup(), cf.getTenant(), cf.getContent(), cf.getLastModified(), cf.getType(), cf.getEncryptedDataKey());
                    String content = cf.getContent();
                    String md5 = MD5Utils.md5Hex((String)content, (String)"UTF-8");
                    LogUtil.DUMP_LOG.info("[dump-all-ok] {}, {}, length={}, md5={}", new Object[]{GroupKey2.getKey(cf.getDataId(), cf.getGroup()), cf.getLastModified(), content.length(), md5});
                }
                LogUtil.DEFAULT_LOG.info("[all-dump] {} / {}", (Object)lastMaxId, (Object)currentMaxId);
                continue;
            }
            lastMaxId += 1000L;
        }
        return true;
    }
}

