/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ConfigOperationService {
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoTagPersistService configInfoTagPersistService;
    private ConfigInfoBetaPersistService configInfoBetaPersistService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigOperationService.class);

    public ConfigOperationService(ConfigInfoPersistService configInfoPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
    }

    public Boolean publishConfig(ConfigForm configForm, ConfigRequestInfo configRequestInfo, String encryptedDataKey) throws NacosException {
        Map<String, Object> configAdvanceInfo = this.getConfigAdvanceInfo(configForm);
        ParamUtils.checkParam(configAdvanceInfo);
        if (AggrWhitelist.isAggrDataId(configForm.getDataId())) {
            LOGGER.warn("[aggr-conflict] {} attempt to publish single data, {}, {}", new Object[]{configRequestInfo.getSrcIp(), configForm.getDataId(), configForm.getGroup()});
            throw new NacosApiException(HttpStatus.FORBIDDEN.value(), ErrorCode.INVALID_DATA_ID, "dataId:" + configForm.getDataId() + " is aggr");
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigInfo configInfo = new ConfigInfo(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getAppName(), configForm.getContent());
        configInfo.setType(configForm.getType());
        configInfo.setEncryptedDataKey(encryptedDataKey);
        if (StringUtils.isBlank((CharSequence)configRequestInfo.getBetaIps())) {
            if (StringUtils.isBlank((CharSequence)configForm.getTag())) {
                this.configInfoPersistService.insertOrUpdate(configRequestInfo.getSrcIp(), configForm.getSrcUser(), configInfo, time, configAdvanceInfo, false);
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), time.getTime()));
            } else {
                this.configInfoTagPersistService.insertOrUpdateTag(configInfo, configForm.getTag(), configRequestInfo.getSrcIp(), configForm.getSrcUser(), time, false);
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configForm.getTag(), time.getTime()));
            }
        } else {
            this.configInfoBetaPersistService.insertOrUpdateBeta(configInfo, configRequestInfo.getBetaIps(), configRequestInfo.getSrcIp(), configForm.getSrcUser(), time, false);
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(true, configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), time.getTime()));
        }
        ConfigTraceService.logPersistenceEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), configRequestInfo.getRequestIpApp(), time.getTime(), InetUtils.getSelfIP(), "pub", configForm.getContent());
        return true;
    }

    public Boolean deleteConfig(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) {
        if (StringUtils.isBlank((CharSequence)tag)) {
            this.configInfoPersistService.removeConfigInfo(dataId, group, namespaceId, clientIp, srcUser);
        } else {
            this.configInfoTagPersistService.removeConfigInfoTag(dataId, group, namespaceId, tag, clientIp, srcUser);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigTraceService.logPersistenceEvent(dataId, group, namespaceId, null, time.getTime(), clientIp, "remove", null);
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, namespaceId, tag, time.getTime()));
        return true;
    }

    public Map<String, Object> getConfigAdvanceInfo(ConfigForm configForm) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)configForm.getConfigTags());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)configForm.getDesc());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)configForm.getUse());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)configForm.getEffect());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)configForm.getType());
        MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)configForm.getSchema());
        return configAdvanceInfo;
    }
}

