/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/history"})
public class HistoryController {
    @Autowired
    protected PersistService persistService;

    @GetMapping(params={"search=accurate"})
    public Page<ConfigHistoryInfo> listConfigHistory(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, ModelMap modelMap) {
        pageNo = null == pageNo ? 1 : pageNo;
        pageSize = null == pageSize ? 100 : pageSize;
        pageSize = Math.min(500, pageSize);
        return this.persistService.findConfigHistory(dataId, group, tenant, pageNo, pageSize);
    }

    @GetMapping
    public ConfigHistoryInfo getConfigHistoryInfo(@RequestParam(value="nid") Long nid) {
        return this.persistService.detailConfigHistory(nid);
    }

    @GetMapping(value={"/previous"})
    public ConfigHistoryInfo getPreviousConfigHistoryInfo(@RequestParam(value="id") Long id) {
        return this.persistService.detailPreviousConfigHistory(id);
    }
}

