/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util.v49;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.sqlparser.impl.vo.QueryTable;

public class JSqlTableInfoHelper {
    private static final Log logger = LogFactory.getLog(JSqlTableInfoHelper.class);
    private static final ThreadLocal<Map<String, QueryTable>> threadLocalMap = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalMainTableAlias = new ThreadLocal();
    private static JSqlTableInfoHelper instance = null;

    private void init() {
        threadLocalMap.set(new HashMap(5));
        threadLocalMainTableAlias.set("");
    }

    private void destroy() {
        threadLocalMap.remove();
        threadLocalMainTableAlias.remove();
    }

    private void addQueryTable(String alias, QueryTable queryTable) {
        threadLocalMap.get().put(alias, queryTable);
    }

    private QueryTable getQueryTable(String alias) {
        return threadLocalMap.get().get(alias);
    }

    private void addQueryTableField(String key, String field) {
        QueryTable queryTable = threadLocalMap.get().get(key);
        queryTable.addField(field);
    }

    private List<QueryTable> getResult() {
        Map<String, QueryTable> localMap = threadLocalMap.get();
        ArrayList<QueryTable> list = new ArrayList<QueryTable>(localMap.values());
        this.destroy();
        return list;
    }

    public static List<QueryTable> getQueryTableInfo(String sql) {
        if (instance == null) {
            instance = new JSqlTableInfoHelper();
        }
        return instance.getQueryTableInfoIns(sql);
    }

    public List<QueryTable> getQueryTableInfoIns(String sql) {
        this.init();
        CCJSqlParserManager parser = new CCJSqlParserManager();
        try {
            Statement stmt = parser.parse((Reader)new StringReader(sql));
            if (stmt instanceof Select) {
                Select selectBody = (Select)stmt;
                if (selectBody instanceof PlainSelect) {
                    PlainSelect plainSelect = (PlainSelect)selectBody;
                    this.handleTable(plainSelect);
                    this.handleColumn(plainSelect);
                }
                if (selectBody instanceof SetOperationList) {
                    SetOperationList selectBodyList = (SetOperationList)selectBody;
                    List selects = selectBodyList.getSelects();
                    for (Select temp : selects) {
                        if (!(temp instanceof PlainSelect)) continue;
                        PlainSelect plainSelect = (PlainSelect)temp;
                        this.handleTable(plainSelect);
                        this.handleColumn(plainSelect);
                    }
                }
            }
            return this.getResult();
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void handleTable(PlainSelect plainSelect) {
        this.handleFromItem(plainSelect.getFromItem());
        List list = plainSelect.getJoins();
        if (list != null) {
            for (Join join : list) {
                Table joinTable = (Table)join.getRightItem();
                this.addTableAlias(joinTable);
            }
        }
    }

    private void handleFromItem(FromItem fromItem) {
        if (fromItem instanceof ParenthesedFromItem) {
            this.handleFromItem(((ParenthesedFromItem)fromItem).getFromItem());
        } else if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            this.addTableAlias(table);
        } else if (fromItem instanceof Select) {
            PlainSelect select = ((Select)fromItem).getPlainSelect();
            this.handleTable(select);
            this.handleColumn(select);
        } else {
            logger.error((Object)("\u4e0d\u652f\u6301\u7684\u7c7b\u578b: " + fromItem.getClass().getName()));
        }
    }

    private void addTableAlias(Table table) {
        String alias = "";
        alias = table.getAlias() != null ? table.getAlias().getName() : table.getName();
        if (threadLocalMainTableAlias.get().isEmpty()) {
            threadLocalMainTableAlias.set(alias);
        }
        this.addQueryTable(alias, new QueryTable(table.getSchemaName(), table.getName(), alias));
    }

    private void handleColumn(PlainSelect plainSelect) {
        List list = plainSelect.getSelectItems();
        final String mainTable = threadLocalMainTableAlias.get();
        for (SelectItem selectItem : list) {
            selectItem.accept((SelectItemVisitor)new SelectItemVisitorAdapter(){

                public void visit(SelectItem item) {
                    Expression exp = item.getExpression();
                    if (exp instanceof AllTableColumns) {
                        AllTableColumns columns = (AllTableColumns)exp;
                        String alias = null;
                        try {
                            alias = columns.getTable().getName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (alias == null) {
                            alias = mainTable;
                        }
                        JSqlTableInfoHelper.this.getQueryTable(alias).setAll(true);
                    } else if (exp instanceof AllColumns) {
                        AllColumns columns = (AllColumns)exp;
                        if ("*".equals(columns.toString())) {
                            JSqlTableInfoHelper.this.getQueryTable(mainTable).setAll(true);
                        }
                    } else if (exp instanceof Column) {
                        Column c = (Column)exp;
                        if (c.getTable() == null) {
                            String str = c.getColumnName();
                            JSqlTableInfoHelper.this.addQueryTableField(mainTable, str);
                        } else {
                            String tableAlias = c.getTable().getName();
                            QueryTable queryTable = null;
                            queryTable = tableAlias == null || tableAlias.isEmpty() ? JSqlTableInfoHelper.this.getQueryTable(mainTable) : JSqlTableInfoHelper.this.getQueryTable(tableAlias);
                            if (queryTable != null) {
                                queryTable.addField(c.getColumnName());
                            }
                        }
                    } else if (exp instanceof Select) {
                        Select select = (Select)exp;
                        PlainSelect selectBody = select.getPlainSelect();
                        JSqlTableInfoHelper.this.handleTable(selectBody);
                        JSqlTableInfoHelper.this.handleColumn(selectBody);
                    } else if (!JSqlTableInfoHelper.this.isSimpleValue(exp)) {
                        String str = exp.toString();
                        boolean isAdded = false;
                        Set keySet = ((Map)threadLocalMap.get()).keySet();
                        for (String alias : keySet) {
                            String temp = alias + ".";
                            if (!str.contains(temp)) continue;
                            isAdded = true;
                            JSqlTableInfoHelper.this.addQueryTableField(alias, str);
                        }
                        if (!isAdded) {
                            JSqlTableInfoHelper.this.addQueryTableField(mainTable, str);
                        }
                    }
                }
            });
        }
    }

    private boolean isSimpleValue(Expression exp) {
        return exp instanceof StringValue || exp instanceof DoubleValue || exp instanceof LongValue;
    }
}

