/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util.v49;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.sqlparser.impl.util.v49.JSqlParserAllTableManager49;
import org.jeecgframework.minidao.sqlparser.impl.vo.SelectSqlInfo;

public class JSqlParserSelectInfoUtil49 {
    private static final Log logger = LogFactory.getLog(JSqlParserSelectInfoUtil49.class);

    public static Map<String, SelectSqlInfo> parseAllSelectTable(String selectSql) throws JSQLParserException {
        if (StringUtils.isEmpty((CharSequence)selectSql)) {
            return null;
        }
        JSqlParserAllTableManager49 allTableManager = new JSqlParserAllTableManager49(selectSql);
        return allTableManager.parse();
    }

    public static SelectSqlInfo parseSelectSqlInfo(String selectSql) throws JSQLParserException {
        if (StringUtils.isEmpty((CharSequence)selectSql)) {
            return null;
        }
        CCJSqlParserManager mgr = new CCJSqlParserManager();
        Statement stmt = mgr.parse((Reader)new StringReader(selectSql));
        if (stmt instanceof Select) {
            Select selectStatement = (Select)stmt;
            return JSqlParserSelectInfoUtil49.parseBySelectBody(selectStatement);
        }
        throw new RuntimeException("\u975e select \u67e5\u8be2sql\uff0c\u4e0d\u505a\u5904\u7406");
    }

    private static SelectSqlInfo parseBySelectBody(Select selectBody) {
        if (selectBody instanceof SetOperationList) {
            List selectBodyList = ((SetOperationList)selectBody).getSelects();
            return JSqlParserSelectInfoUtil49.parseBySelectBody((Select)selectBodyList.get(0));
        }
        if (selectBody instanceof PlainSelect) {
            SelectSqlInfo sqlInfo = new SelectSqlInfo(selectBody);
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem.getAlias() != null) {
                sqlInfo.setFromTableAliasName(fromItem.getAlias().getName());
            }
            if (fromItem instanceof Table) {
                Table fromTable = (Table)fromItem;
                sqlInfo.setFromTableName(fromTable.getName());
            } else if (fromItem instanceof ParenthesedSelect) {
                PlainSelect subSelect = ((ParenthesedSelect)fromItem).getPlainSelect();
                SelectSqlInfo subSqlInfo = JSqlParserSelectInfoUtil49.parseBySelectBody((Select)subSelect);
                sqlInfo.setFromSubSelect(subSqlInfo);
            }
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                Expression expression = selectItem.getExpression();
                if (expression instanceof AllColumns) {
                    sqlInfo.setSelectAll(true);
                    sqlInfo.setSelectFields(null);
                    sqlInfo.setRealSelectFields(null);
                    break;
                }
                if (!(expression instanceof ParenthesedSelect)) continue;
                ParenthesedSelect selectExpressionItem = (ParenthesedSelect)expression;
                Alias alias = selectExpressionItem.getAlias();
                JSqlParserSelectInfoUtil49.handleExpression(sqlInfo, expression, alias);
            }
            return sqlInfo;
        }
        logger.warn((Object)("\u6682\u65f6\u5c1a\u672a\u5904\u7406\u8be5\u7c7b\u578b\u7684 SelectBody: " + selectBody.getClass().getName()));
        throw new RuntimeException("\u6682\u65f6\u5c1a\u672a\u5904\u7406\u8be5\u7c7b\u578b\u7684 SelectBody");
    }

    private static void handleExpression(SelectSqlInfo sqlInfo, Expression expression, Alias alias) {
        String selectField;
        if (expression instanceof Function) {
            JSqlParserSelectInfoUtil49.handleFunctionExpression((Function)expression, sqlInfo);
            return;
        }
        if (expression instanceof ParenthesedSelect) {
            ParenthesedSelect subSelect = (ParenthesedSelect)expression;
            SelectSqlInfo subSqlInfo = JSqlParserSelectInfoUtil49.parseBySelectBody((Select)subSelect);
            sqlInfo.getSelectFields().addAll(subSqlInfo.getSelectFields());
            sqlInfo.getRealSelectFields().addAll(subSqlInfo.getAllRealSelectFields());
            return;
        }
        if (expression instanceof StringValue || expression instanceof NullValue || expression instanceof LongValue || expression instanceof DoubleValue || expression instanceof HexValue || expression instanceof DateValue || expression instanceof TimestampValue || expression instanceof TimeValue) {
            return;
        }
        String realSelectField = selectField = expression.toString();
        if (alias != null) {
            selectField = alias.getName();
        }
        if (expression instanceof Column) {
            Column column = (Column)expression;
            realSelectField = column.getColumnName();
        }
        sqlInfo.addSelectField(selectField, realSelectField);
    }

    private static void handleFunctionExpression(Function functionExp, SelectSqlInfo sqlInfo) {
        ExpressionList expressionList = functionExp.getParameters();
        for (Expression expression : expressionList) {
            JSqlParserSelectInfoUtil49.handleExpression(sqlInfo, expression, null);
        }
    }
}

