/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.api;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.weibo.dto.WeiboSendDto;
import com.jeecg.weibo.exception.BusinessException;
import com.jeecg.weibo.util.HttpUtil;
import com.jeecg.weibo.util.WeiboSendUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboSendApi {
    private static final Logger logger = LoggerFactory.getLogger(WeiboSendApi.class);
    private static final String upload_url_text_url = "https://api.weibo.com/2/statuses/upload_url_text.json?1=1";
    private static String update_url = "https://api.weibo.com/2/statuses/update.json?1=1";
    private static String delete_url = "https://api.weibo.com/2/statuses/destroy.json?1=1";

    public static JSONObject sendWeibo(WeiboSendDto send) {
        JSONObject j = null;
        try {
            logger.info("\u53d1\u5e03\u65b0\u5fae\u535a\u7684\u53c2\u6570\u4e3a:" + send.toString());
            WeiboSendUtil.getSendParmValidate(send);
            if (StringUtils.isEmpty((String)send.getUrl())) {
                String sendUrl = WeiboSendUtil.getSendUrl(update_url, send);
                logger.info("\u53d1\u5e03\u65b0\u5fae\u535a\u7684\u8def\u5f84\u4e3a\uff1a" + sendUrl);
                j = HttpUtil.httpRequest(sendUrl, "POST", "");
            } else {
                String sendUrl = WeiboSendUtil.getSendUrl(upload_url_text_url, send);
                logger.info("\u53d1\u5e03\u65b0\u5fae\u535a\u7684\u8def\u5f84\u4e3a\uff1a" + sendUrl);
                j = HttpUtil.httpRequest(sendUrl, "POST", "");
            }
            if (j != null) {
                logger.info("\u53d1\u5e03\u65b0\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u53d1\u5e03\u65b0\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONObject delWeibo(WeiboSendDto send) {
        JSONObject j = null;
        try {
            logger.info("\u5220\u9664\u5fae\u535a\u7684\u53c2\u6570\u4e3a:" + send.toString());
            WeiboSendUtil.delParmValidate(send);
            String delUrl = WeiboSendUtil.getDelUrl(delete_url, send);
            logger.info("\u5220\u9664\u5fae\u535a\u7684\u8def\u5f84\u4e3a\uff1a" + delUrl);
            j = HttpUtil.httpRequest(delUrl, "POST", "");
            if (j != null) {
                logger.info("\u5220\u9664\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u5220\u9664\u5fae\u535a\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }
}

