/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.qywx.api.base;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.qywx.api.base.JwParamesAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import com.jeecg.qywx.api.core.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwAccessTokenAPI {
    private static final Logger logger = LoggerFactory.getLogger(JwAccessTokenAPI.class);
    public static final String access_token_url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=CorpID&corpsecret=SECRET";

    public static AccessToken getAccessToken(String corpID, String secret) {
        AccessToken accessToken = null;
        String requestUrl = access_token_url.replace("CorpID", corpID).replace("SECRET", secret);
        JSONObject jsonObject = HttpUtil.sendGet(requestUrl);
        if (null != jsonObject) {
            try {
                accessToken = new AccessToken();
                accessToken.setAccesstoken(jsonObject.getString("access_token"));
                accessToken.setExpiresIn(jsonObject.getIntValue("expires_in"));
                logger.info("[ACCESSTOKEN]", (Object)"\u83b7\u53d6ACCESSTOKEN\u6210\u529f:{}", (Object)new Object[]{accessToken});
            }
            catch (Exception e) {
                accessToken = null;
                int errcode = jsonObject.getIntValue("errcode");
                String errmsg = jsonObject.getString("errmsg");
                logger.info("[ACCESSTOKEN]", (Object)"\u83b7\u53d6ACCESSTOKEN\u5931\u8d25 errcode:{} errmsg:{}", (Object)new Object[]{errcode, errmsg});
            }
        }
        return accessToken;
    }

    public static void main(String[] args) {
        try {
            AccessToken s = JwAccessTokenAPI.getAccessToken(JwParamesAPI.corpId, JwParamesAPI.secret);
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

