/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualStoreImpl
implements ContextualStore {
    private static final String GENERATED_ID_PREFIX = ContextualStoreImpl.class.getName();
    private final BiMap<Contextual<?>, String> contextuals;
    private final ConcurrentMap<String, Contextual<?>> passivationCapableContextuals;
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public ContextualStoreImpl() {
        HashBiMap map = HashBiMap.create();
        this.contextuals = Maps.synchronizedBiMap(map);
        this.passivationCapableContextuals = new ConcurrentHashMap();
    }

    @Override
    public <C extends Contextual<I>, I> C getContextual(String id) {
        if (id.startsWith(GENERATED_ID_PREFIX)) {
            return (C)((Contextual)this.contextuals.inverse().get(id));
        }
        return (C)((Contextual)this.passivationCapableContextuals.get(id));
    }

    @Override
    public String putIfAbsent(Contextual<?> contextual) {
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)((Object)contextual);
            this.passivationCapableContextuals.putIfAbsent(passivationCapable.getId(), contextual);
            return passivationCapable.getId();
        }
        if (this.contextuals.containsKey(contextual)) {
            return (String)this.contextuals.get(contextual);
        }
        String id = GENERATED_ID_PREFIX + this.idGenerator.incrementAndGet();
        this.contextuals.put(contextual, id);
        return id;
    }

    @Override
    public <C extends Contextual<I>, I> SerializableContextual<C, I> getSerializableContextual(Contextual<I> contextual) {
        return new SerializableContextualImpl(contextual);
    }

    @Override
    public <C extends Contextual<I>, I> SerializableContextualInstance<C, I> getSerializableContextualInstance(Contextual<I> contextual, I instance, CreationalContext<I> creationalContext) {
        return new SerializableContextualInstanceImpl<Contextual<I>, I>(contextual, instance, creationalContext);
    }

    @Override
    public void cleanup() {
        this.contextuals.clear();
        this.passivationCapableContextuals.clear();
    }
}

