/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.messages.MetadataMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.StereotypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedStereotypes<T, E> {
    private final Set<Annotation> possibleScopeTypes = new HashSet<Annotation>();
    private boolean beanNameDefaulted;
    private boolean alternative;
    private Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
    private final BeanManagerImpl manager;

    public MergedStereotypes(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        this.manager = manager;
        this.merge(stereotypeAnnotations);
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = this.manager.getServices().get(MetaAnnotationStore.class).getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw new ForbiddenStateException(MetadataMessage.STEREOTYPE_NOT_REGISTERED, stereotypeAnnotation);
            }
            if (stereotype.isAlternative()) {
                this.alternative = true;
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            if (stereotype.isBeanNameDefaulted()) {
                this.beanNameDefaulted = true;
            }
            this.stereotypes.add(stereotypeAnnotation.annotationType());
            this.merge(stereotype.getInheritedSterotypes());
        }
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public Set<Annotation> getPossibleScopes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public String toString() {
        return "Merged stereotype model; Any of the sterotypes is an alternative: " + this.alternative + "; possible scopes " + this.possibleScopeTypes;
    }
}

