/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EncodingToCharset {
    private static final Map<String, Charset> encodingToCharsetCache = new HashMap<String, Charset>();
    public static final Charset ISO_8859_1;
    public static final Charset UTF_8;

    public static Charset toCharset(String encoding) throws UnsupportedEncodingException {
        String enc = encoding.toUpperCase(Locale.US);
        Charset charset = encodingToCharsetCache.get(enc);
        if (charset == null) {
            throw new UnsupportedEncodingException(encoding);
        }
        return charset;
    }

    static {
        for (Charset charset : Charset.availableCharsets().values()) {
            encodingToCharsetCache.put(charset.name().toUpperCase(Locale.US), charset);
            for (String alias : charset.aliases()) {
                encodingToCharsetCache.put(alias.toUpperCase(Locale.US), charset);
            }
        }
        ISO_8859_1 = encodingToCharsetCache.get("ISO-8859-1");
        UTF_8 = encodingToCharsetCache.get("UTF-8");
    }
}

