/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.ContentIDUtils;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.spi.AsyncOutputStream;

public class AbstractMultipartRelatedWriter
extends AbstractMultipartWriter {
    protected void writeRelated(MultipartRelatedOutput multipartRelatedOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream, Annotation[] annotations) throws IOException, WebApplicationException {
        for (OutputPart outputPart : multipartRelatedOutput.getParts()) {
            if (outputPart.getHeaders().get((Object)"Content-ID") != null) continue;
            outputPart.getHeaders().putSingle((Object)"Content-ID", (Object)ContentIDUtils.generateContentID());
        }
        OutputPart rootOutputPart = multipartRelatedOutput.getRootPart();
        LinkedHashMap<String, String> mediaTypeParameters = new LinkedHashMap<String, String>(mediaType.getParameters());
        if (mediaTypeParameters.containsKey("boundary")) {
            multipartRelatedOutput.setBoundary((String)mediaTypeParameters.get("boundary"));
        }
        mediaTypeParameters.put("start", (String)rootOutputPart.getHeaders().getFirst((Object)"Content-ID"));
        mediaTypeParameters.put("type", rootOutputPart.getMediaType().getType() + "/" + rootOutputPart.getMediaType().getSubtype());
        if (multipartRelatedOutput.getStartInfo() != null) {
            mediaTypeParameters.put("start-info", multipartRelatedOutput.getStartInfo());
        }
        MediaType modifiedMediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), mediaTypeParameters);
        this.write(multipartRelatedOutput, modifiedMediaType, httpHeaders, entityStream, annotations);
    }

    protected CompletionStage<Void> asyncWriteRelated(MultipartRelatedOutput multipartRelatedOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream, Annotation[] annotations) {
        for (OutputPart outputPart : multipartRelatedOutput.getParts()) {
            if (outputPart.getHeaders().get((Object)"Content-ID") != null) continue;
            outputPart.getHeaders().putSingle((Object)"Content-ID", (Object)ContentIDUtils.generateContentID());
        }
        OutputPart rootOutputPart = multipartRelatedOutput.getRootPart();
        LinkedHashMap<String, String> mediaTypeParameters = new LinkedHashMap<String, String>(mediaType.getParameters());
        if (mediaTypeParameters.containsKey("boundary")) {
            multipartRelatedOutput.setBoundary((String)mediaTypeParameters.get("boundary"));
        }
        mediaTypeParameters.put("start", (String)rootOutputPart.getHeaders().getFirst((Object)"Content-ID"));
        mediaTypeParameters.put("type", rootOutputPart.getMediaType().getType() + "/" + rootOutputPart.getMediaType().getSubtype());
        if (multipartRelatedOutput.getStartInfo() != null) {
            mediaTypeParameters.put("start-info", multipartRelatedOutput.getStartInfo());
        }
        MediaType modifiedMediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), mediaTypeParameters);
        return this.asyncWrite(multipartRelatedOutput, modifiedMediaType, httpHeaders, entityStream, annotations);
    }
}

