/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import __redirected.__JAXPRedirected;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.modules.CallerContext;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.Linkage;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.LocalLoaders;
import org.jboss.modules.Metrics;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderDependency;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.PathUtils;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.Resource;
import org.jboss.modules.SecurityActions;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.NoopModuleLogger;

public final class Module {
    private static final AtomicReference<ModuleLoader> BOOT_MODULE_LOADER;
    static final String[] systemPackages;
    static final String[] systemPaths;
    static volatile ModuleLogger log;
    private static final FastCopyHashSet<ClassFilter> EMPTY_CLASS_FILTERS;
    private static final FastCopyHashSet<PathFilter> EMPTY_PATH_FILTERS;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final LocalLoader fallbackLoader;
    private final Map<String, String> properties;
    private volatile Linkage linkage = Linkage.NONE;
    private static final RuntimePermission GET_CLASS_LOADER;
    private static final RuntimePermission GET_BOOT_MODULE_LOADER;
    private static final RuntimePermission ACCESS_MODULE_LOGGER;
    private static final RuntimePermission ADD_CONTENT_HANDLER_FACTORY;
    private static final RuntimePermission ADD_URL_STREAM_HANDLER_FACTORY;

    Module(ConcreteModuleSpec spec, ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
        this.identifier = spec.getModuleIdentifier();
        this.mainClassName = spec.getMainClass();
        this.fallbackLoader = spec.getFallbackLoader();
        ModuleClassLoader.Configuration configuration = new ModuleClassLoader.Configuration(this, spec.getAssertionSetting(), spec.getResourceLoaders(), spec.getClassFileTransformer());
        ModuleClassLoaderFactory factory = spec.getModuleClassLoaderFactory();
        ModuleClassLoader moduleClassLoader = null;
        if (factory != null) {
            moduleClassLoader = factory.create(configuration);
        }
        if (moduleClassLoader == null) {
            moduleClassLoader = new ModuleClassLoader(configuration);
        }
        this.moduleClassLoader = moduleClassLoader;
        Map<String, String> properties = spec.getProperties();
        this.properties = properties.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, String>(properties);
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    Dependency[] getDependencies() {
        return this.linkage.getSourceList();
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    public Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            ClassLoader oldClassLoader = SecurityActions.setContextClassLoader(this.moduleClassLoader);
            try {
                Class<?> mainClass = Class.forName(this.mainClassName, false, this.moduleClassLoader);
                try {
                    Class.forName(this.mainClassName, true, this.moduleClassLoader);
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t, "Failed to initialize main class '" + this.mainClassName + "'");
                }
                Method mainMethod = mainClass.getMethod("main", String[].class);
                int modifiers = mainMethod.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    throw new NoSuchMethodException("Main method is not static for " + this);
                }
                mainMethod.invoke(null, new Object[]{args});
            }
            finally {
                SecurityActions.setContextClassLoader(oldClassLoader);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadServiceFromCallerModuleLoader(ModuleIdentifier identifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier).loadService(serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.getPathsUnchecked().keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return Module.forClassLoader(cl, false);
    }

    public static Module forClassLoader(ClassLoader cl, boolean search) {
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getModule();
        }
        if (search) {
            return Module.forClassLoader(cl.getParent(), true);
        }
        return null;
    }

    public static ModuleLoader getBootModuleLoader() {
        ModuleLoader loader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_BOOT_MODULE_LOADER);
        }
        while ((loader = BOOT_MODULE_LOADER.get()) == null && !BOOT_MODULE_LOADER.compareAndSet(null, loader = DefaultBootModuleLoaderHolder.INSTANCE)) {
        }
        return loader;
    }

    static void initBootModuleLoader(ModuleLoader loader) {
        BOOT_MODULE_LOADER.set(loader);
    }

    public static ModuleLoader getCallerModuleLoader() {
        Module callerModule = Module.getCallerModule();
        return callerModule == null ? null : callerModule.getModuleLoader();
    }

    public static ModuleLoader getContextModuleLoader() {
        return Module.forClassLoader(Thread.currentThread().getContextClassLoader(), true).getModuleLoader();
    }

    public static Module getModuleFromCallerModuleLoader(ModuleIdentifier identifier) throws ModuleLoadException {
        return Module.getCallerModuleLoader().loadModule(identifier);
    }

    public static Module getCallerModule() {
        return Module.forClass(CallerContext.getCallingClass());
    }

    public Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.moduleLoader.loadModule(identifier);
    }

    public static Class<?> loadClassFromBootModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getBootModuleLoader().loadModule(moduleIdentifier).getClassLoader());
    }

    public static Class<?> loadClassFromCallerModuleLoader(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, Module.getModuleFromCallerModuleLoader(moduleIdentifier).getClassLoader());
    }

    Class<?> loadModuleClass(String className, boolean resolve) {
        LocalLoader fallbackLoader;
        for (String s : systemPackages) {
            if (!className.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        String path = Module.pathOfClass(className);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                Class<?> clazz = loader.loadClassLocal(className, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            return fallbackLoader.loadClassLocal(className, resolve);
        }
        return null;
    }

    URL getResource(String name) {
        List<Resource> resourceList;
        Iterator<Resource> i$;
        LocalLoader fallbackLoader;
        String canonPath = PathUtils.canonicalize(name);
        for (String s : systemPaths) {
            if (!canonPath.startsWith(s)) continue;
            return this.moduleClassLoader.getResource(canonPath);
        }
        log.trace("Attempting to find resource %s in %s", (Object)canonPath, (Object)this);
        String path = Module.pathOf(canonPath);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList2 = loader.loadResourceLocal(canonPath);
                Iterator<Resource> i$2 = resourceList2.iterator();
                if (!i$2.hasNext()) continue;
                Resource resource = i$2.next();
                return resource.getURL();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (i$ = (resourceList = fallbackLoader.loadResourceLocal(canonPath)).iterator()).hasNext()) {
            Resource resource = i$.next();
            return resource.getURL();
        }
        return null;
    }

    Enumeration<URL> getResources(String name) {
        LocalLoader fallbackLoader;
        String canonPath = PathUtils.canonicalize(name);
        for (String s : systemPaths) {
            if (!canonPath.startsWith(s)) continue;
            try {
                return this.moduleClassLoader.getResources(canonPath);
            }
            catch (IOException e) {
                return ConcurrentClassLoader.EMPTY_ENUMERATION;
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)canonPath, (Object)this);
        String path = Module.pathOf(canonPath);
        Map<String, List<LocalLoader>> paths = this.getPathsUnchecked();
        List<LocalLoader> loaders = paths.get(path);
        ArrayList<URL> list = new ArrayList<URL>();
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList = loader.loadResourceLocal(canonPath);
                for (Resource resource : resourceList) {
                    list.add(resource.getURL());
                }
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            List<Resource> resourceList = fallbackLoader.loadResourceLocal(canonPath);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return list.size() == 0 ? ConcurrentClassLoader.EMPTY_ENUMERATION : Collections.enumeration(list);
    }

    public URL getExportedResource(String name) {
        return this.getResource(name);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name);
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name, String defaultVal) {
        return this.properties.containsKey(name) ? this.properties.get(name) : defaultVal;
    }

    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"" + " from " + this.moduleLoader.toString();
    }

    public static ModuleLogger getModuleLogger() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        return log;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_MODULE_LOGGER);
        }
        logger.greeting();
        log = logger;
    }

    public static long getStartTime() {
        return StartTimeHolder.START_TIME;
    }

    public static void registerContentHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONTENT_HANDLER_FACTORY);
        }
        ModularContentHandlerFactory.addHandlerModule(module);
    }

    public static void registerURLStreamHandlerFactoryModule(Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_URL_STREAM_HANDLER_FACTORY);
        }
        ModularURLStreamHandlerFactory.addHandlerModule(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map, FastCopyHashSet<PathFilter> filterStack, FastCopyHashSet<ClassFilter> classFilterStack, FastCopyHashSet<PathFilter> resourceFilterStack, Set<Visited> visited) throws ModuleLoadException {
        long subtract = 0L;
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            List<LocalLoader> list;
            Set<String> paths;
            PathFilter resourceFilter;
            ClassFilter classFilter;
            LocalLoader localLoader;
            if (dependency instanceof ModuleDependency) {
                Object nestedResourceFilters;
                Object nestedClassFilters;
                Object nestedFilters;
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                try {
                    long pauseStart = Metrics.getCurrentCPUTime();
                    try {
                        module = moduleLoader.preloadModule(id);
                    }
                    finally {
                        subtract += Metrics.getCurrentCPUTime() - pauseStart;
                    }
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(id.toString());
                }
                PathFilter importFilter = dependency.getImportFilter();
                if (filterStack.contains(importFilter)) {
                    nestedFilters = filterStack;
                } else {
                    nestedFilters = filterStack.clone();
                    ((FastCopyHashSet)nestedFilters).add(importFilter);
                }
                ClassFilter classImportFilter = dependency.getClassImportFilter();
                if (classImportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classImportFilter)) {
                    nestedClassFilters = classFilterStack;
                } else {
                    nestedClassFilters = classFilterStack.clone();
                    if (classImportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classImportFilter);
                    }
                }
                PathFilter resourceImportFilter = dependency.getResourceImportFilter();
                if (resourceImportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceImportFilter)) {
                    nestedResourceFilters = resourceFilterStack;
                } else {
                    nestedResourceFilters = resourceFilterStack.clone();
                    if (resourceImportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceImportFilter);
                    }
                }
                subtract += module.addExportedPaths(module.getDependencies(), map, (FastCopyHashSet<PathFilter>)nestedFilters, (FastCopyHashSet<ClassFilter>)nestedClassFilters, (FastCopyHashSet<PathFilter>)nestedResourceFilters, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                for (Object filter : classFilterStack.getRawArray()) {
                    if (filter == null || filter == ClassFilters.acceptAll()) continue;
                    localLoader = LocalLoaders.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
                }
                for (Object filter : resourceFilterStack.getRawArray()) {
                    if (filter == null || filter == PathFilters.acceptAll()) continue;
                    localLoader = LocalLoaders.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
                }
                classFilter = classLoaderDependency.getClassImportFilter();
                if (classFilter != ClassFilters.acceptAll()) {
                    localLoader = LocalLoaders.createClassFilteredLocalLoader(classFilter, localLoader);
                }
                if ((resourceFilter = classLoaderDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                    localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceFilter, localLoader);
                }
                PathFilter importFilter = classLoaderDependency.getImportFilter();
                paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    if (!importFilter.accept(path)) continue;
                    list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>();
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            for (Object filter : classFilterStack.getRawArray()) {
                if (filter == null || filter == ClassFilters.acceptAll()) continue;
                localLoader = LocalLoaders.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
            }
            for (Object filter : resourceFilterStack.getRawArray()) {
                if (filter == null || filter == PathFilters.acceptAll()) continue;
                localLoader = LocalLoaders.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
            }
            classFilter = localDependency.getClassImportFilter();
            if (classFilter != ClassFilters.acceptAll()) {
                localLoader = LocalLoaders.createClassFilteredLocalLoader(classFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            PathFilter importFilter = localDependency.getImportFilter();
            paths = localDependency.getPaths();
            for (String path : paths) {
                if (!importFilter.accept(path)) continue;
                list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>();
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
        return subtract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addExportedPaths(Dependency[] dependencies, Map<String, List<LocalLoader>> map, FastCopyHashSet<PathFilter> filterStack, FastCopyHashSet<ClassFilter> classFilterStack, FastCopyHashSet<PathFilter> resourceFilterStack, Set<Visited> visited) throws ModuleLoadException {
        if (!visited.add(new Visited(this, filterStack, classFilterStack, resourceFilterStack))) {
            return 0L;
        }
        long subtract = 0L;
        this.moduleLoader.incScanCount();
        for (Dependency dependency : dependencies) {
            PathFilter resourceFilter;
            LocalLoader localLoader;
            PathFilter exportFilter = dependency.getExportFilter();
            if (exportFilter == PathFilters.rejectAll()) continue;
            if (dependency instanceof ModuleDependency) {
                Object nestedResourceFilters;
                Object nestedClassFilters;
                FastCopyHashSet<PathFilter> nestedFilters;
                Module module;
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                ModuleLoader moduleLoader = moduleDependency.getModuleLoader();
                ModuleIdentifier id = moduleDependency.getIdentifier();
                try {
                    long pauseStart = Metrics.getCurrentCPUTime();
                    try {
                        module = moduleLoader.preloadModule(id);
                    }
                    finally {
                        subtract += Metrics.getCurrentCPUTime() - pauseStart;
                    }
                }
                catch (ModuleLoadException ex) {
                    if (moduleDependency.isOptional()) continue;
                    throw ex;
                }
                if (module == null) {
                    if (moduleDependency.isOptional()) continue;
                    throw new ModuleNotFoundException(id.toString());
                }
                PathFilter importFilter = dependency.getImportFilter();
                if (filterStack.contains(importFilter) && filterStack.contains(exportFilter)) {
                    nestedFilters = filterStack;
                } else {
                    nestedFilters = filterStack.clone();
                    nestedFilters.add(importFilter);
                    nestedFilters.add(exportFilter);
                }
                ClassFilter classImportFilter = dependency.getClassImportFilter();
                ClassFilter classExportFilter = dependency.getClassExportFilter();
                if ((classImportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classImportFilter)) && (classExportFilter == ClassFilters.acceptAll() || classFilterStack.contains(classExportFilter))) {
                    nestedClassFilters = classFilterStack;
                } else {
                    nestedClassFilters = classFilterStack.clone();
                    if (classImportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classImportFilter);
                    }
                    if (classExportFilter != ClassFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedClassFilters).add(classExportFilter);
                    }
                }
                PathFilter resourceImportFilter = dependency.getResourceImportFilter();
                PathFilter resourceExportFilter = dependency.getResourceExportFilter();
                if ((resourceImportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceImportFilter)) && (resourceExportFilter == PathFilters.acceptAll() || resourceFilterStack.contains(resourceExportFilter))) {
                    nestedResourceFilters = resourceFilterStack;
                } else {
                    nestedResourceFilters = resourceFilterStack.clone();
                    if (resourceImportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceImportFilter);
                    }
                    if (resourceExportFilter != PathFilters.acceptAll()) {
                        ((FastCopyHashSet)nestedResourceFilters).add(resourceExportFilter);
                    }
                }
                subtract += module.addExportedPaths(module.getDependencies(), map, nestedFilters, (FastCopyHashSet<ClassFilter>)nestedClassFilters, (FastCopyHashSet<PathFilter>)nestedResourceFilters, visited);
                continue;
            }
            if (dependency instanceof ModuleClassLoaderDependency) {
                PathFilter resourceExportFilter;
                PathFilter resourceImportFilter;
                ClassFilter classExportFilter;
                ModuleClassLoaderDependency classLoaderDependency = (ModuleClassLoaderDependency)dependency;
                localLoader = classLoaderDependency.getLocalLoader();
                for (Object filter : classFilterStack.getRawArray()) {
                    if (filter == null || filter == ClassFilters.acceptAll()) continue;
                    localLoader = LocalLoaders.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
                }
                for (Object filter : resourceFilterStack.getRawArray()) {
                    if (filter == null || filter == PathFilters.acceptAll()) continue;
                    localLoader = LocalLoaders.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
                }
                ClassFilter classImportFilter = classLoaderDependency.getClassImportFilter();
                if (classImportFilter != ClassFilters.acceptAll()) {
                    localLoader = LocalLoaders.createClassFilteredLocalLoader(classImportFilter, localLoader);
                }
                if ((classExportFilter = classLoaderDependency.getClassExportFilter()) != ClassFilters.acceptAll()) {
                    localLoader = LocalLoaders.createClassFilteredLocalLoader(classExportFilter, localLoader);
                }
                if ((resourceImportFilter = classLoaderDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                    localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceImportFilter, localLoader);
                }
                if ((resourceExportFilter = classLoaderDependency.getResourceExportFilter()) != PathFilters.acceptAll()) {
                    localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceExportFilter, localLoader);
                }
                PathFilter importFilter = classLoaderDependency.getImportFilter();
                Set<String> paths = classLoaderDependency.getPaths();
                for (String path : paths) {
                    boolean accept = true;
                    for (Object filter : filterStack.getRawArray()) {
                        if (filter == null || ((PathFilter)filter).accept(path)) continue;
                        accept = false;
                        break;
                    }
                    if (!accept || !importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    List<LocalLoader> list = map.get(path);
                    if (list == null) {
                        list = new ArrayList<LocalLoader>(1);
                        map.put(path, list);
                        list.add(localLoader);
                        continue;
                    }
                    if (list.contains(localLoader)) continue;
                    list.add(localLoader);
                }
                continue;
            }
            if (!(dependency instanceof LocalDependency)) continue;
            LocalDependency localDependency = (LocalDependency)dependency;
            localLoader = localDependency.getLocalLoader();
            for (Object filter : classFilterStack.getRawArray()) {
                if (filter == null || filter == ClassFilters.acceptAll()) continue;
                localLoader = LocalLoaders.createClassFilteredLocalLoader((ClassFilter)filter, localLoader);
            }
            for (Object filter : resourceFilterStack.getRawArray()) {
                if (filter == null || filter == PathFilters.acceptAll()) continue;
                localLoader = LocalLoaders.createPathFilteredLocalLoader((PathFilter)filter, localLoader);
            }
            ClassFilter classFilter = localDependency.getClassExportFilter();
            if (classFilter != ClassFilters.acceptAll()) {
                localLoader = LocalLoaders.createClassFilteredLocalLoader(classFilter, localLoader);
            }
            if ((classFilter = localDependency.getClassImportFilter()) != ClassFilters.acceptAll()) {
                localLoader = LocalLoaders.createClassFilteredLocalLoader(classFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceExportFilter()) != PathFilters.acceptAll()) {
                localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            if ((resourceFilter = localDependency.getResourceImportFilter()) != PathFilters.acceptAll()) {
                localLoader = LocalLoaders.createPathFilteredLocalLoader(resourceFilter, localLoader);
            }
            Set<String> paths = localDependency.getPaths();
            for (String path : paths) {
                boolean accept = true;
                for (Object filter : filterStack.getRawArray()) {
                    if (filter == null || ((PathFilter)filter).accept(path)) continue;
                    accept = false;
                    break;
                }
                if (!accept || !localDependency.getImportFilter().accept(path) || !localDependency.getExportFilter().accept(path)) continue;
                List<LocalLoader> list = map.get(path);
                if (list == null) {
                    list = new ArrayList<LocalLoader>(1);
                    map.put(path, list);
                    list.add(localLoader);
                    continue;
                }
                if (list.contains(localLoader)) continue;
                list.add(localLoader);
            }
        }
        return subtract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Map<String, List<LocalLoader>> getPaths() throws ModuleLoadException {
        oldLinkage = this.linkage;
        state = oldLinkage.getState();
        if (state == Linkage.State.LINKED) {
            return oldLinkage.getPaths();
        }
        intr = false;
        while (true) lbl-1000:
        // 3 sources

        {
            var5_6 = this;
            synchronized (var5_6) {
                block24: {
                    oldLinkage = this.linkage;
                    state = oldLinkage.getState();
                    while (state == Linkage.State.LINKING || state == Linkage.State.NEW) {
                        try {
                            this.wait();
                            oldLinkage = this.linkage;
                            state = oldLinkage.getState();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                    if (state != Linkage.State.LINKED) break block24;
                    var6_7 = oldLinkage.getPaths();
                    return var6_7;
                }
                this.linkage = linkage = new Linkage(oldLinkage.getSourceList(), Linkage.State.LINKING);
            }
            ok = false;
            try {
                this.link(linkage);
                ok = true;
            }
            finally {
                if (ok) continue;
                var6_7 = this;
                synchronized (var6_7) {
                    if (this.linkage == linkage) {
                        this.linkage = oldLinkage;
                        this.notifyAll();
                    }
                }
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    Map<String, List<LocalLoader>> getPathsUnchecked() {
        try {
            return this.getPaths();
        }
        catch (ModuleLoadException e) {
            throw e.toError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void link(Linkage linkage) throws ModuleLoadException {
        HashMap<String, List<LocalLoader>> importsMap = new HashMap<String, List<LocalLoader>>();
        Dependency[] dependencies = linkage.getSourceList();
        long start = Metrics.getCurrentCPUTime();
        long subtractTime = 0L;
        try {
            FastCopyHashSet<Visited> visited = new FastCopyHashSet<Visited>(16);
            FastCopyHashSet<PathFilter> filterStack = new FastCopyHashSet<PathFilter>(8);
            FastCopyHashSet<ClassFilter> classFilterStack = EMPTY_CLASS_FILTERS;
            FastCopyHashSet<PathFilter> resourceFilterStack = EMPTY_PATH_FILTERS;
            subtractTime += this.addPaths(dependencies, importsMap, filterStack, classFilterStack, resourceFilterStack, visited);
            Module module = this;
            synchronized (module) {
                if (this.linkage == linkage) {
                    this.linkage = new Linkage(linkage.getSourceList(), Linkage.State.LINKED, importsMap);
                    this.notifyAll();
                }
            }
        }
        finally {
            this.moduleLoader.addLinkTime(Metrics.getCurrentCPUTime() - start - subtractTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void relinkIfNecessary() throws ModuleLoadException {
        Linkage linkage;
        Linkage oldLinkage = this.linkage;
        if (oldLinkage.getState() != Linkage.State.UNLINKED) {
            return;
        }
        Module module = this;
        synchronized (module) {
            oldLinkage = this.linkage;
            if (oldLinkage.getState() != Linkage.State.UNLINKED) {
                return;
            }
            this.linkage = linkage = new Linkage(oldLinkage.getSourceList(), Linkage.State.LINKING);
        }
        boolean ok = false;
        try {
            this.link(linkage);
            ok = true;
        }
        finally {
            if (!ok) {
                Module module2 = this;
                synchronized (module2) {
                    if (this.linkage == linkage) {
                        this.linkage = oldLinkage;
                        this.notifyAll();
                    }
                }
            }
        }
    }

    void relink() throws ModuleLoadException {
        this.link(this.linkage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDependencies(List<DependencySpec> dependencySpecs) throws ModuleLoadException {
        Module module = this;
        synchronized (module) {
            this.linkage = new Linkage(this.calculateDependencies(dependencySpecs), Linkage.State.UNLINKED, null);
            this.notifyAll();
        }
    }

    private Dependency[] calculateDependencies(List<DependencySpec> dependencySpecs) {
        Dependency[] dependencies = new Dependency[dependencySpecs.size()];
        int i = 0;
        for (DependencySpec spec : dependencySpecs) {
            Dependency dependency = spec.getDependency(this);
            dependencies[i++] = dependency;
        }
        return dependencies;
    }

    String getMainClass() {
        return this.mainClassName;
    }

    Package getPackage(String name) {
        List<LocalLoader> loaders = this.getPathsUnchecked().get(name.replace('.', '/'));
        if (loaders != null) {
            for (LocalLoader localLoader : loaders) {
                Package pkg = localLoader.loadPackageLocal(name);
                if (pkg == null) continue;
                return pkg;
            }
        }
        return null;
    }

    Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        Map<String, List<LocalLoader>> allPaths = this.getPathsUnchecked();
        for (String path : allPaths.keySet()) {
            LocalLoader loader;
            Package pkg;
            String packageName = path.replace('/', '.');
            Iterator<LocalLoader> i$ = allPaths.get(path).iterator();
            if (!i$.hasNext() || (pkg = (loader = i$.next()).loadPackageLocal(packageName)) == null) continue;
            packages.add(pkg);
        }
        return packages.toArray(new Package[packages.size()]);
    }

    static {
        log = NoopModuleLogger.getInstance();
        BOOT_MODULE_LOADER = new AtomicReference();
        EMPTY_CLASS_FILTERS = new FastCopyHashSet(0);
        EMPTY_PATH_FILTERS = new FastCopyHashSet(0);
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        GET_BOOT_MODULE_LOADER = new RuntimePermission("getBootModuleLoader");
        ACCESS_MODULE_LOGGER = new RuntimePermission("accessModuleLogger");
        ADD_CONTENT_HANDLER_FACTORY = new RuntimePermission("addContentHandlerFactory");
        ADD_URL_STREAM_HANDLER_FACTORY = new RuntimePermission("addURLStreamHandlerFactory");
        String pkgsString = AccessController.doPrivileged(new PropertyReadAction("jboss.modules.system.pkgs"));
        ArrayList<String> list = new ArrayList<String>();
        list.add("java.");
        list.add("sun.reflect.");
        list.add("__redirected.");
        if (pkgsString != null) {
            int nc = -1;
            do {
                int i;
                String part;
                if ((part = (nc = pkgsString.indexOf(44, i = nc + 1)) == -1 ? pkgsString.substring(i).trim() : pkgsString.substring(i, nc).trim()).length() <= 0) continue;
                list.add((part + ".").intern());
            } while (nc != -1);
        }
        systemPackages = list.toArray(list.toArray(new String[list.size()]));
        ListIterator<String> iterator = list.listIterator();
        while (iterator.hasNext()) {
            iterator.set(((String)iterator.next()).replace('.', '/'));
        }
        systemPaths = list.toArray(list.toArray(new String[list.size()]));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(ModularURLStreamHandlerFactory.INSTANCE);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    URLConnection.setContentHandlerFactory(ModularContentHandlerFactory.INSTANCE);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                __JAXPRedirected.initAll();
                return null;
            }
        });
    }

    static final class Visited {
        private final Module module;
        private final FastCopyHashSet<PathFilter> filters;
        private final FastCopyHashSet<ClassFilter> classFilters;
        private final FastCopyHashSet<PathFilter> resourceFilters;
        private final int hashCode;

        Visited(Module module, FastCopyHashSet<PathFilter> filters, FastCopyHashSet<ClassFilter> classFilters, FastCopyHashSet<PathFilter> resourceFilters) {
            this.module = module;
            this.filters = filters;
            this.classFilters = classFilters;
            this.resourceFilters = resourceFilters;
            this.hashCode = ((resourceFilters.hashCode() * 13 + classFilters.hashCode()) * 13 + filters.hashCode()) * 13 + module.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return other instanceof Visited && this.equals((Visited)other);
        }

        public boolean equals(Visited other) {
            return this == other || other != null && this.module == other.module && this.filters.equals(other.filters) && this.classFilters.equals(other.classFilters) && this.resourceFilters.equals(other.resourceFilters);
        }
    }
}

