/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.copy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.plugins.copy.CopyMechanism;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractCopyMechanism
implements CopyMechanism {
    private static Logger log = Logger.getLogger(CopyMechanism.class);
    private static File tempDir;

    public static synchronized File getTempDirectory() {
        if (tempDir == null) {
            tempDir = AccessController.doPrivileged(new GetTempDir());
            log.info((Object)("VFS temp dir: " + tempDir));
        }
        return tempDir;
    }

    protected abstract String getType();

    protected abstract boolean isAlreadyModified(VirtualFileHandler var1) throws IOException;

    protected abstract boolean replaceOldHandler(VirtualFileHandler var1, VirtualFileHandler var2, VirtualFileHandler var3) throws IOException;

    protected VirtualFileHandler unwrap(VirtualFileHandler handler) {
        if (handler instanceof DelegatingHandler) {
            handler = ((DelegatingHandler)handler).getDelegate();
        }
        return handler;
    }

    public VirtualFile copy(VirtualFile file, VirtualFileHandler handler) throws IOException, URISyntaxException {
        ExceptionHandler eh;
        VirtualFileHandler unwrapped = this.unwrap(handler);
        if (this.isAlreadyModified(unwrapped)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Should already be " + this.getType() + ": " + unwrapped));
            }
            return file;
        }
        File guidDir = AbstractCopyMechanism.createTempDirectory(AbstractCopyMechanism.getTempDirectory(), GUID.asString());
        File copy = this.copy(guidDir, handler);
        FileSystemContext fileSystemContext = new FileSystemContext(copy);
        VFSContext oldVFSContext = handler.getVFSContext();
        Map<String, String> newOptions = fileSystemContext.getOptions();
        Map<String, String> oldOptions = oldVFSContext.getOptions();
        if (newOptions != null && oldOptions != null && !oldOptions.isEmpty()) {
            newOptions.putAll(oldOptions);
        }
        if ((eh = oldVFSContext.getExceptionHandler()) != null) {
            fileSystemContext.setExceptionHandler(eh);
        }
        VirtualFileHandler newHandler = fileSystemContext.getRoot();
        VirtualFileHandler parent = handler.getParent();
        if (parent != null && this.replaceOldHandler(parent, handler, newHandler)) {
            parent.replaceChild(handler, newHandler);
        }
        return newHandler.getVirtualFile();
    }

    protected File copy(File guidDir, VirtualFileHandler handler) throws IOException {
        File copy = AbstractCopyMechanism.createTempDirectory(guidDir, handler.getName());
        AbstractCopyMechanism.unpack(handler, copy, false);
        return copy;
    }

    protected static File createTempDirectory(File parent, String name) {
        File file = new File(parent, name);
        if (!file.mkdir()) {
            throw new IllegalArgumentException("Cannot create directory: " + file);
        }
        file.deleteOnExit();
        return file;
    }

    protected static void unpack(VirtualFileHandler root, File file, boolean writeRoot) throws IOException {
        List<VirtualFileHandler> children;
        if (writeRoot) {
            AbstractCopyMechanism.rewrite(root, file);
        }
        if (!root.isLeaf() && (children = root.getChildren(true)) != null && !children.isEmpty()) {
            for (VirtualFileHandler handler : children) {
                File next = new File(file, handler.getName());
                if (!handler.isLeaf() && !next.mkdir()) {
                    throw new IllegalArgumentException("Problems creating new directory: " + next);
                }
                next.deleteOnExit();
                AbstractCopyMechanism.unpack(handler, next, handler.isLeaf());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void rewrite(VirtualFileHandler handler, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = handler.openStream();
        try {
            byte[] bytes = new byte[1024];
            while (in.available() > 0) {
                int length = in.read(bytes);
                if (length <= 0) continue;
                ((OutputStream)out).write(bytes, 0, length);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTempDir
    implements PrivilegedAction<File> {
        private GetTempDir() {
        }

        @Override
        public File run() {
            String tempDirKey = System.getProperty("vfs.temp.dir", "jboss.server.temp.dir");
            return new File(System.getProperty(tempDirKey, System.getProperty("java.io.tmpdir")));
        }
    }
}

