/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.oracle;

import java.io.Serializable;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.spi.ExceptionSorter;

public class OracleExceptionSorter
implements ExceptionSorter,
Serializable {
    private static final long serialVersionUID = 573723525408205079L;

    @Override
    public boolean isExceptionFatal(SQLException e) {
        int errorCode = Math.abs(e.getErrorCode());
        if (errorCode == 28 || errorCode == 600 || errorCode == 1012 || errorCode == 1014 || errorCode == 1033 || errorCode == 1034 || errorCode == 1035 || errorCode == 1089 || errorCode == 1090 || errorCode == 1092 || errorCode == 1094 || errorCode == 2396 || errorCode == 3106 || errorCode == 3111 || errorCode == 3113 || errorCode == 3114 || errorCode >= 12100 && errorCode <= 12299 || errorCode == 17002 || errorCode == 17008 || errorCode == 17410 || errorCode == 17447) {
            return true;
        }
        String sqlState = e.getSQLState();
        if ("08000".equals(sqlState)) {
            return true;
        }
        String errorText = e.getMessage().toUpperCase();
        return !(errorCode >= 20000 && errorCode < 21000 || errorText.indexOf("SOCKET") <= -1 && errorText.indexOf("CONNECTION HAS ALREADY BEEN CLOSED") <= -1 && errorText.indexOf("BROKEN PIPE") <= -1);
    }
}

