/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import org.jboss.forge.roaster.Internal;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;

public class SyntaxErrorImpl
implements SyntaxError,
Internal {
    private final JavaType<?> parent;
    private final IProblem problem;

    public SyntaxErrorImpl(JavaType<?> parent, Object internal) {
        this.parent = parent;
        this.problem = (IProblem)internal;
    }

    public String getDescription() {
        int line = this.problem.getSourceLineNumber();
        int begin = this.problem.getSourceStart();
        int end = this.problem.getSourceEnd();
        String snippit = this.parent.toString().substring(begin, end);
        String message = "Line " + line + " near <" + begin + "," + end + ">: \"" + snippit + "\" - " + this.problem.getMessage();
        return message;
    }

    public Object getInternal() {
        return this.problem;
    }

    public String toString() {
        return this.getDescription();
    }

    public int getLine() {
        return this.problem.getSourceLineNumber();
    }

    public int getColumn() {
        int position = this.problem.getSourceStart();
        if (position >= 0 && this.parent != null && this.parent.getInternal() instanceof CompilationUnit) {
            return ((CompilationUnit)this.parent.getInternal()).getColumnNumber(position);
        }
        return -1;
    }

    public boolean isError() {
        return this.problem.isError();
    }

    public boolean isWarning() {
        return this.problem.isWarning();
    }
}

