/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.text.edits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;

public final class TextEditCopier {
    private TextEdit fEdit;
    private Map<TextEdit, TextEdit> fCopies;

    public TextEditCopier(TextEdit edit) {
        Assert.isNotNull(edit);
        this.fEdit = edit;
        this.fCopies = new HashMap<TextEdit, TextEdit>();
    }

    public TextEdit perform() {
        TextEdit result = this.doCopy(this.fEdit);
        if (result != null) {
            for (TextEdit edit : this.fCopies.keySet()) {
                edit.postProcessCopy(this);
            }
        }
        return result;
    }

    public TextEdit getCopy(TextEdit original) {
        Assert.isNotNull(original);
        return this.fCopies.get(original);
    }

    private TextEdit doCopy(TextEdit edit) {
        TextEdit result = edit.doCopy();
        List<TextEdit> children = edit.internalGetChildren();
        if (children != null) {
            ArrayList<TextEdit> newChildren = new ArrayList<TextEdit>(children.size());
            for (TextEdit textEdit : children) {
                TextEdit childCopy = this.doCopy(textEdit);
                childCopy.internalSetParent(result);
                newChildren.add(childCopy);
            }
            result.internalSetChildren(newChildren);
        }
        this.addCopy(edit, result);
        return result;
    }

    private void addCopy(TextEdit original, TextEdit copy) {
        this.fCopies.put(original, copy);
    }
}

