/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.Module;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleCollisionHook;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.util.ArrayMap;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.debug.Debug;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.messages.Msg;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.report.resolution.ResolutionReport;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.Storage;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleException;
import org.jboss.forge.roaster._shade.org.osgi.framework.InvalidSyntaxException;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.bundle.CollisionHook;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.resolver.ResolverHook;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleCapability;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleRequirement;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleRevision;

class OSGiFrameworkHooks {
    private final CoreResolverHookFactory resolverHookFactory;
    private final ModuleCollisionHook collisionHook;

    OSGiFrameworkHooks(EquinoxContainer container, Storage storage) {
        this.resolverHookFactory = new CoreResolverHookFactory(container, storage);
        this.collisionHook = new BundleCollisionHook(container);
    }

    public ResolverHookFactory getResolverHookFactory() {
        return this.resolverHookFactory;
    }

    public ModuleCollisionHook getModuleCollisionHook() {
        return this.collisionHook;
    }

    public void initBegin() {
        this.resolverHookFactory.inInit = true;
    }

    public void initEnd() {
        this.resolverHookFactory.inInit = false;
    }

    static class BundleCollisionHook
    implements ModuleCollisionHook {
        final Debug debug;
        final EquinoxContainer container;

        public BundleCollisionHook(EquinoxContainer container) {
            this.container = container;
            this.debug = container.getConfiguration().getDebug();
        }

        @Override
        public void filterCollisions(int operationType, Module target, Collection<Module> collisionCandidates) {
            switch (this.container.getConfiguration().BSN_VERSION) {
                case 1: {
                    return;
                }
                case 2: {
                    collisionCandidates.clear();
                    return;
                }
                case 3: {
                    Bundle targetBundle = target.getBundle();
                    ArrayMap<Bundle, Module> candidateBundles = new ArrayMap<Bundle, Module>(collisionCandidates.size());
                    for (Module module : collisionCandidates) {
                        candidateBundles.put(module.getBundle(), module);
                    }
                    this.notifyCollisionHooks(operationType, targetBundle, candidateBundles);
                    collisionCandidates.retainAll(candidateBundles.getValues());
                    return;
                }
            }
            throw new IllegalStateException("Bad configuration: " + this.container.getConfiguration().BSN_VERSION);
        }

        private void notifyCollisionHooks(final int operationType, final Bundle target, Collection<Bundle> collisionCandidates) {
            final ShrinkableCollection<Bundle> shrinkable = new ShrinkableCollection<Bundle>(collisionCandidates);
            if (System.getSecurityManager() == null) {
                this.notifyCollisionHooksPriviledged(operationType, target, shrinkable);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        this.notifyCollisionHooksPriviledged(operationType, target, shrinkable);
                        return null;
                    }
                });
            }
        }

        void notifyCollisionHooksPriviledged(int operationType, Bundle target, Collection<Bundle> collisionCandidates) {
            ServiceRegistry registry;
            if (this.debug.DEBUG_HOOKS) {
                Debug.println("notifyCollisionHooks(" + operationType + ", " + target + ", " + collisionCandidates + ")");
            }
            if ((registry = this.container.getServiceRegistry()) != null) {
                registry.notifyHooksPrivileged(CollisionHook.class, "filterCollisions", (hook, hookRegistration) -> hook.filterCollisions(operationType, target, collisionCandidates));
            }
        }
    }

    static class CoreResolverHookFactory
    implements ResolverHookFactory {
        final Debug debug;
        final EquinoxContainer container;
        final Storage storage;
        volatile boolean inInit = false;

        public CoreResolverHookFactory(EquinoxContainer container, Storage storage) {
            this.container = container;
            this.debug = container.getConfiguration().getDebug();
            this.storage = storage;
        }

        void handleHookException(Throwable t, Object hook, String method) {
            if (this.debug.DEBUG_HOOKS) {
                Debug.println(String.valueOf(hook.getClass().getName()) + "." + method + "() exception:");
                if (t != null) {
                    Debug.printStackTrace(t);
                }
            }
            String message = NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, hook.getClass().getName(), method);
            throw new RuntimeException(message, new BundleException(message, 12, t));
        }

        private ServiceReferenceImpl<ResolverHookFactory>[] getHookReferences(final ServiceRegistry registry, final BundleContextImpl context) {
            return AccessController.doPrivileged(new PrivilegedAction<ServiceReferenceImpl<ResolverHookFactory>[]>(){

                @Override
                public ServiceReferenceImpl<ResolverHookFactory>[] run() {
                    try {
                        ServiceReferenceImpl<?>[] result = registry.getServiceReferences(context, ResolverHookFactory.class.getName(), null, false);
                        return result;
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        return null;
                    }
                }
            });
        }

        @Override
        public ResolverHook begin(Collection<BundleRevision> triggers) {
            ArrayList<HookReference> hookRefs;
            ModuleContainer mContainer;
            if (this.debug.DEBUG_HOOKS) {
                Debug.println("ResolverHook.begin");
            }
            Module systemModule = (mContainer = this.storage.getModuleContainer()) == null ? null : mContainer.getModule(0L);
            ServiceRegistry registry = this.container.getServiceRegistry();
            if (registry == null || systemModule == null) {
                return new CoreResolverHook(Collections.emptyList(), systemModule);
            }
            BundleContextImpl context = (BundleContextImpl)EquinoxContainer.secureAction.getContext(systemModule.getBundle());
            ServiceReferenceImpl<ResolverHookFactory>[] refs = this.getHookReferences(registry, context);
            ArrayList<HookReference> arrayList = hookRefs = refs == null ? Collections.emptyList() : new ArrayList<HookReference>(refs.length);
            if (refs != null) {
                ServiceReferenceImpl<ResolverHookFactory>[] serviceReferenceImplArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReferenceImpl<ResolverHookFactory> hookRef = serviceReferenceImplArray[n2];
                    ResolverHookFactory factory = EquinoxContainer.secureAction.getService(hookRef, context);
                    if (factory != null) {
                        try {
                            ResolverHook hook = factory.begin(triggers);
                            if (hook != null) {
                                hookRefs.add(new HookReference(hookRef, hook, context));
                            }
                        }
                        catch (Throwable t) {
                            try {
                                new CoreResolverHook(hookRefs, systemModule).end();
                            }
                            catch (Throwable throwable) {}
                            this.handleHookException(t, factory, "begin");
                        }
                    }
                    ++n2;
                }
            }
            return new CoreResolverHook(hookRefs, systemModule);
        }

        class CoreResolverHook
        implements ResolutionReport.Listener,
        ResolverHook {
            private final List<HookReference> hooks;
            private final Module systemModule;
            private volatile ResolutionReport resolutionReport;

            CoreResolverHook(List<HookReference> hooks, Module systemModule) {
                this.hooks = hooks;
                this.systemModule = systemModule;
            }

            @Override
            public void filterResolvable(Collection<BundleRevision> candidates) {
                if (CoreResolverHookFactory.this.debug.DEBUG_HOOKS) {
                    Debug.println("ResolverHook.filterResolvable(" + candidates + ")");
                }
                if (this.isBootInit()) {
                    Iterator<BundleRevision> iCandidates = candidates.iterator();
                    while (iCandidates.hasNext()) {
                        BundleRevision revision = iCandidates.next();
                        if ((revision.getTypes() & 1) != 0 || revision.getBundle().getBundleId() == 0L) continue;
                        iCandidates.remove();
                    }
                }
                if (this.hooks.isEmpty()) {
                    return;
                }
                candidates = new ShrinkableCollection<BundleRevision>(candidates);
                for (HookReference hookRef : this.hooks) {
                    if (hookRef.reference.getBundle() == null) {
                        CoreResolverHookFactory.this.handleHookException(null, hookRef.hook, "filterResolvable");
                        continue;
                    }
                    try {
                        hookRef.hook.filterResolvable(candidates);
                    }
                    catch (Throwable t) {
                        CoreResolverHookFactory.this.handleHookException(t, hookRef.hook, "filterResolvable");
                    }
                }
            }

            private boolean isBootInit() {
                return this.systemModule == null || !Module.RESOLVED_SET.contains((Object)this.systemModule.getState()) || this.systemModule.getState().equals((Object)Module.State.STARTING) && CoreResolverHookFactory.this.inInit;
            }

            @Override
            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                if (CoreResolverHookFactory.this.debug.DEBUG_HOOKS) {
                    Debug.println("ResolverHook.filterSingletonCollisions(" + singleton + ", " + collisionCandidates + ")");
                }
                if (this.hooks.isEmpty()) {
                    return;
                }
                collisionCandidates = new ShrinkableCollection<BundleCapability>(collisionCandidates);
                for (HookReference hookRef : this.hooks) {
                    if (hookRef.reference.getBundle() == null) {
                        CoreResolverHookFactory.this.handleHookException(null, hookRef.hook, "filterSingletonCollisions");
                        continue;
                    }
                    try {
                        hookRef.hook.filterSingletonCollisions(singleton, collisionCandidates);
                    }
                    catch (Throwable t) {
                        CoreResolverHookFactory.this.handleHookException(t, hookRef.hook, "filterSingletonCollisions");
                    }
                }
            }

            @Override
            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                if (CoreResolverHookFactory.this.debug.DEBUG_HOOKS) {
                    Debug.println("ResolverHook.filterMatches(" + requirement + ", " + candidates + ")");
                }
                if (this.hooks.isEmpty()) {
                    return;
                }
                candidates = new ShrinkableCollection<BundleCapability>(candidates);
                for (HookReference hookRef : this.hooks) {
                    if (hookRef.reference.getBundle() == null) {
                        CoreResolverHookFactory.this.handleHookException(null, hookRef.hook, "filterMatches");
                        continue;
                    }
                    try {
                        hookRef.hook.filterMatches(requirement, candidates);
                    }
                    catch (Throwable t) {
                        CoreResolverHookFactory.this.handleHookException(t, hookRef.hook, "filterMatches");
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void end() {
                if (CoreResolverHookFactory.this.debug.DEBUG_HOOKS) {
                    Debug.println("ResolverHook.end");
                }
                if (this.hooks.isEmpty()) {
                    return;
                }
                try {
                    missingHook = null;
                    endError = null;
                    endBadHook = null;
                    for (HookReference hookRef : this.hooks) {
                        if (hookRef.reference.getBundle() == null) {
                            if (missingHook != null) continue;
                            missingHook = hookRef;
                            continue;
                        }
                        try {
                            if (hookRef.hook instanceof ResolutionReport.Listener) {
                                ((ResolutionReport.Listener)hookRef.hook).handleResolutionReport(this.resolutionReport);
                            }
                            hookRef.hook.end();
                        }
                        catch (Throwable t) {
                            if (endError != null) continue;
                            endError = t;
                            endBadHook = hookRef;
                        }
                    }
                    if (missingHook != null) {
                        CoreResolverHookFactory.this.handleHookException(null, missingHook.hook, "end");
                    }
                    if (endError != null) {
                        CoreResolverHookFactory.this.handleHookException(endError, endBadHook.hook, "end");
                    }
                }
                finally {
                    var9_9 = this.hooks.iterator();
                    if (true) ** GOTO lbl39
                }
                {
                }
                do {
                    hookRef = var9_9.next();
                    hookRef.context.ungetService(hookRef.reference);
lbl39:
                    // 2 sources

                } while (var9_9.hasNext());
                this.hooks.clear();
            }

            @Override
            public void handleResolutionReport(ResolutionReport report) {
                this.resolutionReport = report;
            }
        }

        static class HookReference {
            final ServiceReferenceImpl<ResolverHookFactory> reference;
            final ResolverHook hook;
            final BundleContextImpl context;

            public HookReference(ServiceReferenceImpl<ResolverHookFactory> reference, ResolverHook hook, BundleContextImpl context) {
                this.reference = reference;
                this.hook = hook;
                this.context = context;
            }
        }
    }
}

