/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd;

public final class StreamHasher {
    private static final long SEED = 3141592653589793238L;
    private static final long EMPTY_STRING_HASH = new StreamHasher().computeHashInternal();
    long hashedOffset = 0L;
    int state = 0;
    int a = -1573762602;
    int b = -1573762602;
    int c = (int)((long)this.c + 731459039L);
    char previousCharacter;

    public void addChunk(char[] chunk) {
        int pos = 0;
        while (pos < chunk.length) {
            char cc = chunk[pos];
            switch (this.state++) {
                case -1: {
                    throw new IllegalStateException("addChunk is called after computeHash.");
                }
                case 0: 
                case 2: 
                case 4: {
                    this.previousCharacter = cc;
                    break;
                }
                case 1: {
                    this.a += this.previousCharacter | cc << 16;
                    break;
                }
                case 3: {
                    this.b += this.previousCharacter | cc << 16;
                    break;
                }
                case 5: {
                    this.c += this.previousCharacter | cc << 16;
                    this.mix();
                    this.state = 0;
                }
            }
            ++pos;
            ++this.hashedOffset;
        }
    }

    public long computeHash() {
        if (this.state < 0) {
            throw new IllegalStateException("computeHash method is called more than once.");
        }
        return this.computeHashInternal() ^ EMPTY_STRING_HASH;
    }

    private long computeHashInternal() {
        switch (this.state) {
            case 1: {
                this.a += this.previousCharacter;
                break;
            }
            case 3: {
                this.b += this.previousCharacter;
                break;
            }
            case 5: {
                this.c += this.previousCharacter;
            }
        }
        this.state = -1;
        this.finalMix();
        return (long)this.c & 0xFFFFFFFFL | (long)this.b << 32;
    }

    public static long hash(String str) {
        StreamHasher hasher = new StreamHasher();
        hasher.addChunk(str.toCharArray());
        return hasher.computeHash();
    }

    private void mix() {
        this.a -= this.c;
        this.a ^= Integer.rotateLeft(this.c, 4);
        this.c += this.b;
        this.b -= this.a;
        this.b ^= Integer.rotateLeft(this.a, 6);
        this.a += this.c;
        this.c -= this.b;
        this.c ^= Integer.rotateLeft(this.b, 8);
        this.b += this.a;
        this.a -= this.c;
        this.a ^= Integer.rotateLeft(this.c, 16);
        this.c += this.b;
        this.b -= this.a;
        this.b ^= Integer.rotateLeft(this.a, 19);
        this.a += this.c;
        this.c -= this.b;
        this.c ^= Integer.rotateLeft(this.b, 4);
        this.b += this.a;
    }

    private void finalMix() {
        this.c ^= this.b;
        this.c -= Integer.rotateLeft(this.b, 14);
        this.a ^= this.c;
        this.a -= Integer.rotateLeft(this.c, 11);
        this.b ^= this.a;
        this.b -= Integer.rotateLeft(this.a, 25);
        this.c ^= this.b;
        this.c -= Integer.rotateLeft(this.b, 16);
        this.a ^= this.c;
        this.a -= Integer.rotateLeft(this.c, 4);
        this.b ^= this.a;
        this.b -= Integer.rotateLeft(this.a, 14);
        this.c ^= this.b;
        this.c -= Integer.rotateLeft(this.b, 24);
    }
}

