/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.Importer;

public class Types {
    private static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("(?i)(?![0-9])[a-z0-9$_]+");
    private static final List<Class<?>> PRIMITIVE_CLASSES = Arrays.asList(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private static final List<String> PRIMITIVE_CLASS_NAMES = Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char");
    private static final List<String> PRIMITIVE_TYPES = Arrays.asList("Boolean", "Byte", "Double", "Float", "Integer", "Long", "Short", "String");
    private static final Pattern CLASS_ARRAY_PATTERN = Pattern.compile("\\[+(B|F|C|D|I|J|S|Z|L)([0-9a-zA-Z\\.\\$]*);?");
    private static final Pattern JAVA_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final Pattern SIMPLE_ARRAY_PATTERN = Pattern.compile("^((.)+)(\\[\\])+$");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern WILDCARD_AWARE_TYPE_PATTERN = Pattern.compile("\\?|^\\s*(\\?\\s+(?:extends|super)\\s+)?([A-Za-z$_]\\S*)\\s*$");
    private static final List<String> LANG_TYPES = Arrays.asList("Appendable", "AutoCloseable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Boolean", "Byte", "Character", "Character.Subset", "Character.UnicodeBlock", "Class", "ClassLoader", "ClassValue", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "ProcessBuilder.Redirect", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "Exception", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "RuntimeException", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "Deprecated", "Override", "SafeVarargs", "SuppressWarnings");

    private Types() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean areEquivalent(String left, String right) {
        if (left.equals(Objects.requireNonNull(right))) {
            return true;
        }
        String leftName = Types.stripGenerics(Types.toSimpleName(left));
        String rightName = Types.stripGenerics(Types.toSimpleName(right));
        String leftPackage = Types.getPackage(left);
        String rightPackage = Types.getPackage(right);
        if (leftName.equals(rightName)) {
            if (!leftPackage.isEmpty() && !rightPackage.isEmpty()) {
                return leftPackage.equals(rightPackage);
            }
            return leftPackage.isEmpty() || rightPackage.isEmpty();
        }
        return false;
    }

    public static String toSimpleName(String type) {
        String[] tokens;
        Object result = Objects.requireNonNull(type);
        if (Types.isGeneric(Types.stripArray(type))) {
            result = Types.stripGenerics((String)result);
        }
        if ((tokens = Types.tokenizeClassName((String)result)) != null) {
            result = tokens[tokens.length - 1];
        }
        if (Types.isGeneric(type)) {
            ArrayList<Object> simpleParameters = new ArrayList<Object>();
            StringTokenizer tok = new StringTokenizer(Types.getGenericsTypeParameter(type), ",");
            while (tok.hasMoreTokens()) {
                Object simpleType;
                Object typeParameter = tok.nextToken();
                while (Types.incompleteGenerics((String)typeParameter) && tok.hasMoreElements()) {
                    typeParameter = (String)typeParameter + "," + tok.nextToken();
                }
                if ("?".equals(typeParameter = ((String)typeParameter).trim())) {
                    simpleType = typeParameter;
                } else {
                    Matcher matcher = WILDCARD_AWARE_TYPE_PATTERN.matcher((CharSequence)typeParameter);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("Cannot parse type parameter " + (String)typeParameter);
                    }
                    simpleType = Types.toSimpleName(matcher.group(2));
                    if (matcher.start(1) >= 0) {
                        simpleType = (matcher.group(1) + " " + (String)simpleType).replaceAll("\\s{2,}?", " ");
                    }
                }
                simpleParameters.add(simpleType);
            }
            String generics = new StringBuilder("<>").insert(1, String.join((CharSequence)",", simpleParameters)).toString();
            result = Types.isArray((String)result) ? new StringBuilder((String)result).insert(((String)result).indexOf("["), generics).toString() : (String)result + generics;
        }
        return result;
    }

    public static String toResolvedType(String type, Importer<?> importer) {
        Import imprt;
        Objects.requireNonNull(type);
        Objects.requireNonNull(importer);
        if (Types.isPrimitive(type)) {
            return type;
        }
        String strippedType = Types.stripGenerics(Types.stripArray(type));
        StringBuilder builder = new StringBuilder();
        String typeToUse = Types.isJavaLang(type) ? Types.toSimpleName(strippedType) : ((imprt = importer.getImport(type)) != null ? imprt.getSimpleName() : strippedType);
        builder.append(typeToUse);
        if (Types.isGeneric(type)) {
            StringJoiner genericJoiner = new StringJoiner(",");
            for (String genericPart : Types.splitGenerics(type)) {
                String resolved = Types.toResolvedType(genericPart, importer);
                resolved = resolved.replace("?extends", "? extends ");
                resolved = resolved.replace("?super", "? super ");
                genericJoiner.add(resolved);
            }
            builder.append("<").append(genericJoiner.toString()).append(">");
        }
        return builder.append(Types.getArraySuffix(type)).toString();
    }

    public static String[] tokenizeClassName(String className) {
        return JAVA_SEPARATOR_PATTERN.split(Objects.requireNonNull(className));
    }

    public static boolean isQualified(String typeName) {
        return typeName.contains(".");
    }

    public static String getPackage(String typeName) {
        if (typeName.contains(".")) {
            return typeName.substring(0, typeName.lastIndexOf("."));
        }
        return "";
    }

    public static boolean isSimpleName(String name) {
        return SIMPLE_NAME_PATTERN.matcher(Objects.requireNonNull(name)).matches();
    }

    public static boolean isJavaLang(String type) {
        String simpleType = Types.stripArray(Objects.requireNonNull(type));
        String packageName = Types.getPackage(simpleType);
        if (!packageName.isBlank() && !packageName.equals("java.lang")) {
            return false;
        }
        simpleType = Types.stripGenerics(simpleType);
        simpleType = Types.toSimpleName(simpleType);
        return LANG_TYPES.contains(simpleType);
    }

    public static boolean isBasicType(String type) {
        return Types.isPrimitive(type) || PRIMITIVE_TYPES.contains(Objects.requireNonNull(type));
    }

    public static boolean isGeneric(String type) {
        return type.contains("<");
    }

    public static boolean validateGenerics(String type) {
        int genericStart = type.indexOf(60);
        if (genericStart < 0) {
            return false;
        }
        String typeWithoutArray = Types.stripArray(type);
        if (!Types.validateName(typeWithoutArray.substring(0, genericStart))) {
            return false;
        }
        String typeArgs = typeWithoutArray.substring(genericStart + 1, typeWithoutArray.lastIndexOf(62));
        StringTokenizer tok = new StringTokenizer(typeArgs, ", ");
        while (tok.hasMoreTokens()) {
            Object typeArg = tok.nextToken();
            while (Types.incompleteGenerics((String)typeArg) && tok.hasMoreElements()) {
                typeArg = (String)typeArg + "," + tok.nextToken();
            }
            if (Types.validateNameWithGenerics((String)typeArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateNameWithGenerics(String name) {
        return Types.isGeneric(name) || Types.validateName(name) || WILDCARD_AWARE_TYPE_PATTERN.matcher(name).matches();
    }

    private static boolean incompleteGenerics(String name) {
        int gtCount;
        int ltCount = name.length() - name.replaceAll("<", "").length();
        return ltCount != (gtCount = name.length() - name.replaceAll(">", "").length());
    }

    private static boolean validateName(String name) {
        return IDENTIFIER_PATTERN.matcher(name).matches();
    }

    public static String stripGenerics(String type) {
        String typeToString = Objects.requireNonNull(type);
        if (Types.isClassArray(typeToString)) {
            typeToString = Types.fixClassArray(typeToString);
        }
        if (Types.isGeneric(typeToString)) {
            return typeToString.substring(0, typeToString.indexOf(60)) + typeToString.substring(typeToString.lastIndexOf(62) + 1).trim();
        }
        return typeToString;
    }

    public static String getGenerics(String type) {
        if (Types.isGeneric(type)) {
            return "<" + Types.getGenericsTypeParameter(type) + ">";
        }
        return "";
    }

    public static String getGenericsTypeParameter(String type) {
        if (Types.isGeneric(type)) {
            return Types.stripArray(type).replaceFirst("^[^<]*<(.*?)>$", "$1");
        }
        return "";
    }

    public static boolean isArray(String type) {
        if (type.charAt(0) == '[' && CLASS_ARRAY_PATTERN.matcher(Objects.requireNonNull(type)).matches()) {
            return true;
        }
        if (!type.endsWith("]")) {
            return false;
        }
        Matcher matcher = SIMPLE_ARRAY_PATTERN.matcher(type);
        if (matcher.find()) {
            String candidateType = matcher.group(1);
            return Types.validateNameWithGenerics(candidateType);
        }
        return false;
    }

    public static String stripArray(String type) {
        String result = Objects.requireNonNull(type);
        if (Types.isClassArray(type)) {
            result = Types.fixClassArray(type);
        }
        if (Types.isArray(result)) {
            Matcher matcher = SIMPLE_ARRAY_PATTERN.matcher(result);
            if (matcher.find()) {
                int idx;
                for (idx = result.length() - 2; idx > 1 && result.charAt(idx - 2) == '['; idx -= 2) {
                }
                result = result.substring(0, idx);
            } else {
                return result;
            }
        }
        return result;
    }

    private static boolean isClassArray(String type) {
        if (type == null || type.length() == 0 || type.charAt(0) != '[') {
            return false;
        }
        Matcher matcher = CLASS_ARRAY_PATTERN.matcher(type);
        return matcher.find();
    }

    private static String fixClassArray(String type) {
        Matcher matcher = CLASS_ARRAY_PATTERN.matcher(type);
        Object result = type;
        if (matcher.find()) {
            int dim = Types.getArrayDimension(type, true);
            switch (matcher.group(1).charAt(0)) {
                case 'B': {
                    result = "byte";
                    break;
                }
                case 'F': {
                    result = "float";
                    break;
                }
                case 'C': {
                    result = "char";
                    break;
                }
                case 'D': {
                    result = "double";
                    break;
                }
                case 'I': {
                    result = "int";
                    break;
                }
                case 'J': {
                    result = "long";
                    break;
                }
                case 'S': {
                    result = "short";
                    break;
                }
                case 'Z': {
                    result = "boolean";
                    break;
                }
                case 'L': {
                    result = matcher.group(2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid array format " + type);
                }
            }
            for (int j = 0; j < dim; ++j) {
                result = (String)result + "[]";
            }
        }
        return result;
    }

    public static boolean isPrimitive(String type) {
        return PRIMITIVE_CLASS_NAMES.contains(Objects.requireNonNull(type));
    }

    public static Class<?> toPrimitive(String type) {
        for (Class<?> c : PRIMITIVE_CLASSES) {
            if (!c.getSimpleName().equals(type)) continue;
            return c;
        }
        return null;
    }

    private static int getArrayDimension(String name, boolean isBasic) {
        int count = 0;
        String rawName = isBasic ? Objects.requireNonNull(name) : Types.stripGenerics(name);
        for (char c : rawName.toCharArray()) {
            if (c != '[') continue;
            ++count;
        }
        return count;
    }

    public static int getArrayDimension(String name) {
        return Types.getArrayDimension(name, false);
    }

    public static String getArraySuffix(String type) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Types.getArrayDimension(type); ++i) {
            builder.append("[]");
        }
        return builder.toString();
    }

    public static <O extends JavaType<O>> String rebuildGenericNameWithArrays(String resolvedTypeName, Type<O> type) {
        StringBuilder resolvedType = new StringBuilder(Types.stripArray(resolvedTypeName));
        resolvedType.append(Types.getGenerics(type.toString()));
        for (int j = 0; j < Types.getArrayDimension(type.getName()); ++j) {
            resolvedType.append("[]");
        }
        return resolvedType.toString();
    }

    public static String getDefaultValue(Class<?> clazz) {
        return Types.getDefaultValue(clazz.getName());
    }

    public static String getDefaultValue(String type) {
        if (Types.isPrimitive(type)) {
            if (type.equals(Boolean.TYPE.getName())) {
                return "false";
            }
            if (type.equals(Float.TYPE.getName()) || type.equals(Double.TYPE.getName())) {
                return "0.0";
            }
            return "0";
        }
        return "null";
    }

    public static String[] splitGenerics(String typeName) {
        String workingString = typeName.replaceAll("\\s", "");
        int begin = workingString.indexOf(60);
        int end = workingString.lastIndexOf(62);
        if (begin == -1 || end == -1) {
            return new String[0];
        }
        workingString = workingString.substring(begin + 1, end);
        int depth = 0;
        StringBuilder currentPart = new StringBuilder();
        ArrayList<String> genericParts = new ArrayList<String>();
        for (int currentIndex = 0; currentIndex < workingString.length(); ++currentIndex) {
            char currentChar = workingString.charAt(currentIndex);
            if (currentChar == ',' && depth == 0) {
                genericParts.add(currentPart.toString());
                currentPart.setLength(0);
                continue;
            }
            if (currentChar == '<') {
                ++depth;
            } else if (currentChar == '>') {
                --depth;
            }
            currentPart.append(currentChar);
        }
        if (currentPart.length() != 0) {
            genericParts.add(currentPart.toString());
        }
        return genericParts.toArray(new String[genericParts.size()]);
    }
}

