/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.MBeanServer;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.txn.TransactionLogger;
import org.jboss.as.txn.TransactionMessages;
import org.jboss.as.txn.subsystem.LogStoreDefinition;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.LogStoreTransactionDefinition;
import org.jboss.as.txn.subsystem.LogStoreTransactionParticipantDefinition;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem10Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem11Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem12Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class TransactionExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "transactions";
    private static final String RESOURCE_NAME = TransactionExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ServiceName MBEAN_SERVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    static final PathElement LOG_STORE_PATH = PathElement.pathElement((String)"log-store", (String)"log-store");
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"transactions");
    static final PathElement PARTECIPANT_PATH = PathElement.pathElement((String)"participants");
    static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transactions");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, TransactionExtension.class.getClassLoader(), true, false);
    }

    static MBeanServer getMBeanServer(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController serviceController = serviceRegistry.getService(MBEAN_SERVER_SERVICE_NAME);
        if (serviceController == null) {
            throw TransactionMessages.MESSAGES.jmxSubsystemNotInstalled();
        }
        return (MBeanServer)serviceController.getValue();
    }

    public void initialize(ExtensionContext context) {
        TransactionLogger.ROOT_LOGGER.debug("Initializing Transactions Extension");
        LogStoreResource resource = new LogStoreResource();
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new TransactionSubsystemRootResourceDefinition(registerRuntimeOnly));
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration logStoreChild = registration.registerSubModel((ResourceDefinition)new LogStoreDefinition(resource));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration transactionChild = logStoreChild.registerSubModel((ResourceDefinition)new LogStoreTransactionDefinition(resource));
            ManagementResourceRegistration partecipantChild = transactionChild.registerSubModel((ResourceDefinition)LogStoreTransactionParticipantDefinition.INSTANCE);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)TransactionSubsystem12Parser.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_0.getUriString(), (XMLElementReader)TransactionSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_1.getUriString(), (XMLElementReader)TransactionSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_2.getUriString(), (XMLElementReader)TransactionSubsystem12Parser.INSTANCE);
    }
}

