/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.lang.instrument.ClassFileTransformer;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.DelegatingClassFileTransformer;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;

public class ClassFileTransformerProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DelegatingClassFileTransformer transformer = deploymentUnit.getAttachment(DelegatingClassFileTransformer.ATTACHMENT_KEY);
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        Module module = deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null || transformer == null) {
            return;
        }
        try {
            for (String transformerClassName : moduleSpecification.getClassFileTransformers()) {
                transformer.addTransformer((ClassFileTransformer)module.getClassLoader().loadClass(transformerClassName).newInstance());
            }
            transformer.setActive(true);
        }
        catch (Exception e) {
            throw ServerMessages.MESSAGES.failedToInstantiateClassFileTransformer(ClassFileTransformer.class.getSimpleName(), e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

