/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ExtensionInfo;
import org.jboss.as.server.deployment.module.ResourceRoot;

public final class ManifestExtensionNameProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (!deploymentRoot.getRoot().getName().endsWith(".jar")) {
            return;
        }
        Manifest manifest = deploymentRoot.getAttachment(Attachments.MANIFEST);
        if (manifest == null) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String extensionName = mainAttributes.getValue(Attributes.Name.EXTENSION_NAME);
        ServerLogger.DEPLOYMENT_LOGGER.debugf("Found Extension-Name manifest entry %s in %s", extensionName, deploymentRoot.getRoot().getPathName());
        if (extensionName == null) {
            return;
        }
        String implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendorId = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        String specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        ExtensionInfo info = new ExtensionInfo(extensionName, specVersion, implVersion, implVendorId);
        deploymentUnit.putAttachment(Attachments.EXTENSION_INFORMATION, info);
        phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

