/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;

public class DeploymentVisibilityProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        HashMap<ModuleIdentifier, DeploymentUnit> deployments = new HashMap<ModuleIdentifier, DeploymentUnit>();
        deploymentUnit.addToAttachmentList(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS, deploymentUnit);
        this.buildModuleMap(deploymentUnit, deployments);
        for (ModuleDependency dependency : moduleSpec.getAllDependencies()) {
            DeploymentUnit sub = (DeploymentUnit)deployments.get(dependency.getIdentifier());
            if (sub == null) continue;
            deploymentUnit.addToAttachmentList(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS, sub);
        }
    }

    private void buildModuleMap(DeploymentUnit deploymentUnit, Map<ModuleIdentifier, DeploymentUnit> modules) {
        if (deploymentUnit.getParent() == null) {
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit sub : subDeployments) {
                ModuleIdentifier identifier = sub.getAttachment(Attachments.MODULE_IDENTIFIER);
                if (identifier == null) continue;
                modules.put(identifier, sub);
            }
        } else {
            DeploymentUnit parent = deploymentUnit.getParent();
            List<DeploymentUnit> subDeployments = parent.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            ModuleIdentifier parentIdentifier = parent.getAttachment(Attachments.MODULE_IDENTIFIER);
            if (parentIdentifier != null) {
                modules.put(parentIdentifier, parent);
            }
            for (DeploymentUnit sub : subDeployments) {
                ModuleIdentifier identifier;
                if (sub == deploymentUnit || (identifier = sub.getAttachment(Attachments.MODULE_IDENTIFIER)) == null) continue;
                modules.put(identifier, sub);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

