/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.client.protocol.Protocol;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXProtocolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJMXProtocol<T extends JMXProtocolConfiguration>
implements Protocol<T> {
    public abstract String getProtocolName();

    public Class<T> getProtocolConfigurationClass() {
        return JMXProtocolConfiguration.class;
    }

    public ProtocolDescription getDescription() {
        return new ProtocolDescription(this.getProtocolName());
    }

    public ContainerMethodExecutor getExecutor(T config, ProtocolMetaData metaData, CommandCallback callback) {
        if (metaData.hasContext(JMXContext.class)) {
            MBeanServerConnection mbeanServer = ((JMXContext)metaData.getContext(JMXContext.class)).getConnection();
            HashMap<String, String> protocolProps = new HashMap<String, String>();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(config.getClass());
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    String key = propertyDescriptor.getName();
                    Object value = propertyDescriptor.getReadMethod().invoke(config, new Object[0]);
                    if (value == null) continue;
                    protocolProps.put(key, "" + value);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot obtain protocol config");
            }
            return new JMXMethodExecutor(mbeanServer, callback, "jboss.arquillian:service=jmx-test-runner", protocolProps);
        }
        throw new IllegalStateException("No " + JMXContext.class.getName() + " was found in " + ProtocolMetaData.class.getName() + ". The JMX Protocol can not be used without a connection, please verify your protocol configuration or contact the DeployableContainer developer");
    }
}

