/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.page.PageExtension;

public class PageExtensionRegistryImpl
implements PageExtensionRegistry {
    private Map<String, PageExtension> pageExtensions = new HashMap<String, PageExtension>();

    @Override
    public void register(PageExtension ... extensions) {
        for (PageExtension extension : extensions) {
            this.pageExtensions.put(extension.getName(), extension);
        }
    }

    @Override
    public void register(Collection<PageExtension> extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("The parameter [extensions] is null.");
        }
        for (PageExtension extension : extensions) {
            this.pageExtensions.put(extension.getName(), extension);
        }
    }

    @Override
    public PageExtension getExtension(String name) {
        return this.pageExtensions.get(name);
    }

    @Override
    public Collection<PageExtension> getExtensions() {
        return Collections.unmodifiableCollection(this.pageExtensions.values());
    }

    @Override
    public void flush() {
        this.pageExtensions.clear();
    }
}

