/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded;

import jakarta.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.weld.embedded.ContextClassLoaderManager;
import org.jboss.arquillian.container.weld.embedded.Utils;
import org.jboss.arquillian.container.weld.embedded.WebArchiveClassLoader;
import org.jboss.arquillian.container.weld.embedded.WeldMockConfiguration;
import org.jboss.arquillian.container.weld.embedded.mock.BeansXmlUtil;
import org.jboss.arquillian.container.weld.embedded.mock.TestContainer;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.xml.BeansXmlParser;

public class WeldMockContainer
implements DeployableContainer<WeldMockConfiguration> {
    private static final String SUFFIX_WEB_ARCHIVE = ".war";
    @Inject
    @ContainerScoped
    private InstanceProducer<WeldMockConfiguration> configuration;
    @Inject
    @DeploymentScoped
    private InstanceProducer<TestContainer> testContainerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<Bootstrap> bootstrapProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<WeldManager> weldManagerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<BeanManager> beanManagerProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ContextClassLoaderManager> contextClassLoaderManagerProducer;
    private ServiceRegistry serviceRegistry;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public Class<WeldMockConfiguration> getConfigurationClass() {
        return WeldMockConfiguration.class;
    }

    public void setup(WeldMockConfiguration configuration) {
        this.configuration.set((Object)configuration);
    }

    public void start() throws LifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ShrinkWrapClassLoader classLoader = this.getClassLoader(archive);
        ContextClassLoaderManager classLoaderManager = new ContextClassLoaderManager(classLoader);
        classLoaderManager.enable();
        this.serviceRegistry = new SimpleServiceRegistry();
        this.serviceRegistry.add(ResourceLoader.class, (Service)new ClassLoaderResourceLoader((ClassLoader)classLoader));
        BeansXmlParser beansXmlParser = new BeansXmlParser();
        BeansXml beansXml = BeansXmlUtil.prepareBeansXml(beansXmlParser, Utils.findBeansXml(archive), true);
        Environments environment = Environments.valueOf((String)((WeldMockConfiguration)this.configuration.get()).getEnvironment());
        TestContainer container = new TestContainer(Utils.findArchiveId(archive), beansXml, Utils.findBeanClasses(archive, (ClassLoader)classLoader, beansXml, (ResourceLoader)this.serviceRegistry.get(ResourceLoader.class), (Environment)environment), (Environment)environment, true);
        Bootstrap bootstrap = container.getBootstrap();
        this.contextClassLoaderManagerProducer.set((Object)classLoaderManager);
        try {
            container.startContainer((Environment)environment);
        }
        finally {
            this.testContainerProducer.set((Object)container);
            this.bootstrapProducer.set((Object)bootstrap);
        }
        WeldManager manager = container.getBeanManager((BeanDeploymentArchive)container.getDeployment().getBeanDeploymentArchives().iterator().next());
        this.weldManagerProducer.set((Object)manager);
        this.beanManagerProducer.set((Object)manager);
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        TestContainer container = (TestContainer)this.testContainerProducer.get();
        if (container != null) {
            container.stopContainer();
        }
        ContextClassLoaderManager classLoaderManager = (ContextClassLoaderManager)this.contextClassLoaderManagerProducer.get();
        classLoaderManager.disable();
    }

    public void stop() throws LifecycleException {
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Weld EE Container does not support deployment of Descriptors");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Weld EE Container does not support undeployment of Descriptors");
    }

    private ShrinkWrapClassLoader getClassLoader(Archive<?> archive) {
        return archive.getName().endsWith(SUFFIX_WEB_ARCHIVE) ? new WebArchiveClassLoader(archive.getClass().getClassLoader(), archive) : new ShrinkWrapClassLoader(archive.getClass().getClassLoader(), new Archive[]{archive});
    }
}

