/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee.reqreporter;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.javasimon.Split;
import org.javasimon.javaee.SimonServletFilter;
import org.javasimon.javaee.reqreporter.RequestReporter;
import org.javasimon.utils.SimonUtils;

public class PlainRequestReporter
implements RequestReporter {
    private SimonServletFilter simonServletFilter;

    @Override
    public void reportRequest(HttpServletRequest request, Split requestSplit, List<Split> splits) {
        StringBuilder messageBuilder = new StringBuilder("Web request is too long (" + SimonUtils.presentNanoTime((long)requestSplit.runningFor()) + ") [" + requestSplit.getStopwatch().getNote() + "]");
        for (Split split : splits) {
            if (!this.shouldBeAddedSplit(split)) continue;
            messageBuilder.append("\n\t").append(split.getStopwatch().getName()).append(": ").append(SimonUtils.presentNanoTime((long)split.runningFor()));
        }
        this.reportMessage(messageBuilder.toString());
    }

    protected void reportMessage(String message) {
        this.simonServletFilter.getManager().message(message);
    }

    protected boolean shouldBeAddedSplit(Split split) {
        return true;
    }

    @Override
    public void setSimonServletFilter(SimonServletFilter simonServletFilter) {
        this.simonServletFilter = simonServletFilter;
    }
}

