/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Getter<T> {
    private final String name;
    private final Class<T> type;
    private final String subType;
    private final Method method;

    Getter(String name, Class<T> type, String subType, Method method) {
        this.name = name;
        this.type = type;
        this.method = method;
        this.subType = subType;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public T get(Object source) {
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            Object value = this.method.invoke(source, new Object[0]);
            return (T)value;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }
}

