/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.legal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.URLInputStreamFacade;
import org.jasig.maven.legal.util.ResourceFinder;

public class PackageLegalMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String noticeFile = "NOTICE";
    protected String licenseFile = "LICENSE";
    protected String targetDirectory = "META-INF";

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        if ("pom".equals(this.project.getPackaging())) {
            logger.info((CharSequence)("Skipping inclusion of legal files for pom project: " + this.project.getName()));
            return;
        }
        File targetOutputDir = this.getTargetDirectory();
        ResourceFinder resourceFinder = this.getResourceFinder();
        this.copyLegalFile(resourceFinder, this.noticeFile, targetOutputDir, "NOTICE");
        this.copyLegalFile(resourceFinder, this.licenseFile, targetOutputDir, "LICENSE");
        logger.info((CharSequence)("Copied NOTICE and LICENSE to: " + targetOutputDir));
    }

    protected void copyLegalFile(ResourceFinder resourceFinder, String legalFile, File targetOutputDir, String outputFileName) throws MojoFailureException {
        URL resourceUrl;
        Log logger = this.getLog();
        try {
            resourceUrl = resourceFinder.findResource(legalFile);
        }
        catch (MojoFailureException e) {
            throw new MojoFailureException("Could not find required " + outputFileName + " file: " + legalFile, (Throwable)e);
        }
        File destFile = new File(targetOutputDir, outputFileName);
        try {
            FileUtils.copyStreamToFile((InputStreamFacade)new URLInputStreamFacade(resourceUrl), (File)destFile);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to copy '" + resourceUrl + "' to '" + destFile + "'", (Throwable)e);
        }
        logger.debug((CharSequence)("Copied '" + resourceUrl + "' to '" + destFile + "'"));
    }

    protected File getTargetDirectory() {
        Build build = this.project.getBuild();
        String outputDirectory = build.getOutputDirectory();
        File outputDirectoryFile = new File(outputDirectory);
        return new File(outputDirectoryFile, this.targetDirectory);
    }

    protected ResourceFinder getResourceFinder() throws MojoExecutionException {
        ResourceFinder finder = new ResourceFinder(this.project);
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            finder.setCompileClassPath(classpathElements);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finder.setPluginClassPath(((Object)((Object)this)).getClass().getClassLoader());
        return finder;
    }
}

