/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.infinispan.tools.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ToolUtils {
    public static final String EMPTY = "";

    public static String getBaseFileName(String absoluteFileName) {
        int slash = absoluteFileName.lastIndexOf(File.separatorChar);
        int dot = absoluteFileName.lastIndexOf(46);
        return absoluteFileName.substring(slash + 1, dot);
    }

    public static void printDocument(Document doc, OutputStream out) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    public static Optional<Node> findFirstChildByTagName(Node parent, String tagName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!tagName.equals(child.getLocalName())) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    public static Optional<Node> findFirstChildByPath(Node parent, String fullPath) {
        String[] paths = fullPath.split("/", 2);
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!paths[0].equals(child.getLocalName())) continue;
            return paths.length == 2 ? ToolUtils.findFirstChildByPath(child, paths[1]) : Optional.of(child);
        }
        return Optional.empty();
    }

    public static List<Dependency> parseXMLDependencies(Document document) {
        LinkedList<Dependency> dependencyList = new LinkedList<Dependency>();
        Node dependencies = document.getElementsByTagName("dependencies").item(0);
        for (Node dependency = dependencies.getFirstChild(); dependency != null; dependency = dependency.getNextSibling()) {
            if (!"dependency".equals(dependency.getLocalName())) continue;
            Optional<Node> groupIdNode = ToolUtils.findFirstChildByTagName(dependency, "groupId");
            if (!groupIdNode.isPresent()) {
                groupIdNode = ToolUtils.findFirstChildByTagName(dependency, "packageName");
            }
            String groupId = groupIdNode.map(ToolUtils::textFromNode).get();
            String artifactId = ToolUtils.findFirstChildByTagName(dependency, "artifactId").map(ToolUtils::textFromNode).orElse(EMPTY);
            String version = ToolUtils.findFirstChildByTagName(dependency, "version").map(ToolUtils::textFromNode).orElse(EMPTY);
            dependencyList.add(new Dependency(groupId, artifactId, version, dependency));
        }
        return dependencyList;
    }

    public static void removeEmptyLinesFromFile(File file) throws IOException {
        List lines = Files.lines(file.toPath()).filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
        try (FileWriter writer = new FileWriter(file);){
            for (String line : lines) {
                writer.write(line);
                writer.write(System.lineSeparator());
            }
        }
    }

    public static String textFromNode(Node node) {
        assert (node != null);
        return node.getTextContent().trim();
    }
}

