/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.OAuth2Configuration;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.security.HostnameVerificationPolicy;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;

public class OAuth2ConfigurationBuilder
implements Builder<OAuth2Configuration> {
    private final AttributeSet attributes;
    private final OAuth2IntrospectValidator.Builder validatorBuilder = OAuth2IntrospectValidator.builder();
    private final RealmsConfigurationBuilder realms;

    OAuth2ConfigurationBuilder(RealmsConfigurationBuilder realms) {
        this.realms = realms;
        this.attributes = OAuth2Configuration.attributeDefinitionSet();
    }

    boolean isChanged() {
        return this.attributes.isModified();
    }

    public OAuth2ConfigurationBuilder clientId(String clientId) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_ID).set((Object)clientId);
        this.validatorBuilder.clientId(clientId);
        return this;
    }

    public OAuth2ConfigurationBuilder clientSecret(String clientSecret) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_SECRET).set((Object)clientSecret);
        this.validatorBuilder.clientSecret(clientSecret);
        return this;
    }

    public OAuth2ConfigurationBuilder introspectionUrl(String introspectionUrl) {
        this.attributes.attribute(OAuth2Configuration.INTROSPECTION_URL).set((Object)introspectionUrl);
        try {
            this.validatorBuilder.tokenIntrospectionUrl(new URL(introspectionUrl));
        }
        catch (MalformedURLException e) {
            throw Server.log.invalidUrl();
        }
        return this;
    }

    public OAuth2ConfigurationBuilder clientSSLContext(String value) {
        this.attributes.attribute(OAuth2Configuration.CLIENT_SSL_CONTEXT).set((Object)value);
        this.validatorBuilder.useSslContext(this.realms.getSSLContext(value));
        return this;
    }

    public OAuth2ConfigurationBuilder hostVerificationPolicy(String value) {
        this.attributes.attribute(OAuth2Configuration.HOST_VERIFICATION_POLICY).set((Object)value);
        HostnameVerifier verifier = HostnameVerificationPolicy.valueOf(value).getVerifier();
        this.validatorBuilder.useSslHostnameVerifier(verifier);
        return this;
    }

    OAuth2IntrospectValidator.Builder getValidatorBuilder() {
        return this.validatorBuilder;
    }

    public void validate() {
    }

    public OAuth2Configuration create() {
        return new OAuth2Configuration(this.attributes.protect());
    }

    public OAuth2ConfigurationBuilder read(OAuth2Configuration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

