/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.LdapAttributeMappingConfiguration;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfiguration;

public class LdapIdentityMappingConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> RDN_IDENTIFIER = AttributeDefinition.builder((String)"rdnIdentifier", null, String.class).immutable().build();
    static final AttributeDefinition<String> SEARCH_BASE_DN = AttributeDefinition.builder((String)"searchBaseDn", null, String.class).immutable().build();
    static final AttributeDefinition<Boolean> SEARCH_RECURSIVE = AttributeDefinition.builder((String)"searchRecursive", (Object)false, Boolean.class).immutable().build();
    static final AttributeDefinition<String> FILTER_NAME = AttributeDefinition.builder((String)"filterName", (Object)"(rdn_identifier={0})", String.class).immutable().build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.IDENTITY_MAPPING.toString());
    private final AttributeSet attributes;
    private final List<LdapAttributeMappingConfiguration> attributeMappings;
    private final List<LdapUserPasswordMapperConfiguration> userPasswordMapper;
    private final List<ConfigurationInfo> subElements = new ArrayList<ConfigurationInfo>();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapIdentityMappingConfiguration.class, new AttributeDefinition[]{RDN_IDENTIFIER, SEARCH_BASE_DN, SEARCH_RECURSIVE, FILTER_NAME});
    }

    LdapIdentityMappingConfiguration(AttributeSet attributes, List<LdapAttributeMappingConfiguration> attributeMappings, List<LdapUserPasswordMapperConfiguration> userPasswordMapper) {
        this.attributes = attributes.checkProtection();
        this.attributeMappings = attributeMappings;
        this.userPasswordMapper = userPasswordMapper;
        this.subElements.addAll(attributeMappings);
        this.subElements.addAll(userPasswordMapper);
    }

    List<LdapAttributeMappingConfiguration> attributeMappings() {
        return this.attributeMappings;
    }

    List<LdapUserPasswordMapperConfiguration> userPasswordMapper() {
        return this.userPasswordMapper;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }
}

