/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;

public class JwtConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<List> AUDIENCE = AttributeDefinition.builder((String)"audience", null, List.class).build();
    static final AttributeDefinition<String> CLIENT_SSL_CONTEXT = AttributeDefinition.builder((String)"clientSslContext", null, String.class).build();
    static final AttributeDefinition<String> HOST_NAME_VERIFICATION_POLICY = AttributeDefinition.builder((String)"hostNameVerificationPolicy", null, String.class).build();
    static final AttributeDefinition<List> ISSUER = AttributeDefinition.builder((String)"issuer", null, List.class).build();
    static final AttributeDefinition<Long> JKU_TIMEOUT = AttributeDefinition.builder((String)"jkuTimeout", null, Long.class).build();
    static final AttributeDefinition<String> PUBLIC_KEY = AttributeDefinition.builder((String)"publicKey", null, String.class).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.JWT.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(JwtConfiguration.class, new AttributeDefinition[]{AUDIENCE, CLIENT_SSL_CONTEXT, HOST_NAME_VERIFICATION_POLICY, ISSUER, JKU_TIMEOUT, PUBLIC_KEY});
    }

    JwtConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtConfiguration that = (JwtConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "JwtConfiguration{attributes=" + this.attributes + '}';
    }
}

