/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;

public class EndpointConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> SOCKET_BINDING = AttributeDefinition.builder((String)"socket-binding", null, String.class).build();
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).build();
    static final AttributeDefinition<Boolean> ADMIN = AttributeDefinition.builder((String)"admin", (Object)true, Boolean.class).build();
    static final AttributeDefinition<Boolean> METRICS_AUTH = AttributeDefinition.builder((String)"metrics-auth", (Object)true, Boolean.class).build();
    private final List<ProtocolServerConfiguration> connectors;
    private final SinglePortRouterConfiguration singlePort;
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENDPOINTS.toString());
    private final AttributeSet attributes;
    private final List<ConfigurationInfo> configs = new ArrayList<ConfigurationInfo>();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EndpointConfiguration.class, new AttributeDefinition[]{SOCKET_BINDING, SECURITY_REALM, ADMIN, METRICS_AUTH});
    }

    EndpointConfiguration(AttributeSet attributes, List<ProtocolServerConfiguration> connectors, SinglePortRouterConfiguration singlePort) {
        this.attributes = attributes.checkProtection();
        this.connectors = connectors;
        this.singlePort = singlePort;
        this.configs.addAll(connectors);
    }

    public List<ConfigurationInfo> subElements() {
        return this.configs;
    }

    public SinglePortRouterConfiguration singlePortRouter() {
        return this.singlePort;
    }

    public List<ProtocolServerConfiguration> connectors() {
        return this.connectors;
    }

    public boolean admin() {
        return (Boolean)this.attributes.attribute(ADMIN).get();
    }

    public boolean metricsAuth() {
        return (Boolean)this.attributes.attribute(METRICS_AUTH).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String socketBinding() {
        return (String)this.attributes.attribute(SOCKET_BINDING).get();
    }
}

