/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.component.inputfile.InputFileProgressEvent;
import com.icesoft.faces.component.inputfile.UploadConfig;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.context.StringResource;
import com.icesoft.faces.utils.MessageUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputFileRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog((Class)InputFileRenderer.class);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String id = component.getClientId(context);
        InputFile c = (InputFile)component;
        BridgeFacesContext facesContext = (BridgeFacesContext)context;
        ResponseWriter writer = context.getResponseWriter();
        StringWriter iframeContentWriter = new StringWriter();
        c.renderIFrame(iframeContentWriter, facesContext);
        String iframeContent = iframeContentWriter.toString();
        String frameName = ClientIdPool.get((String)(id + ":uploadFrame"));
        String pseudoURL = ((ResourceRegistry)context).registerResource((Resource)new StringResource(iframeContent){

            public void withOptions(Resource.Options options) throws IOException {
                super.withOptions(options);
                options.setMimeType("text/html");
            }
        }).toString();
        UploadConfig uploadConfig = c.storeContentAndConfig(facesContext, id, iframeContent);
        writer.startElement("iframe", (UIComponent)c);
        writer.writeAttribute("src", (Object)pseudoURL, null);
        writer.writeAttribute("id", (Object)frameName, null);
        writer.writeAttribute("name", (Object)frameName, null);
        writer.writeAttribute("class", (Object)c.getStyleClass(), null);
        writer.writeAttribute("style", (Object)c.getStyle(), null);
        writer.writeAttribute("width", (Object)(c.getWidth() + "px"), null);
        writer.writeAttribute("height", (Object)(c.getHeight() + "px"), null);
        writer.writeAttribute("title", (Object)"Input File Frame", null);
        writer.writeAttribute("frameborder", (Object)"0", null);
        writer.writeAttribute("marginwidth", (Object)"0", null);
        writer.writeAttribute("marginheight", (Object)"0", null);
        writer.writeAttribute("scrolling", (Object)"no", null);
        writer.writeAttribute("allowtransparency", (Object)"true", null);
        writer.endElement("iframe");
        String submitOnUpload = c.getValidatedSubmitOnUpload();
        if (!submitOnUpload.equals("none")) {
            boolean preUpload = submitOnUpload.equals("preUpload") || submitOnUpload.equals("preAndPostUpload");
            boolean postUpload = submitOnUpload.equals("postUpload") || submitOnUpload.equals("preAndPostUpload");
            writer.startElement("script", (UIComponent)c);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("id", (Object)id, null);
            writer.writeText((Object)("var register = function() {var frameElem = document.getElementById('" + frameName + "');" + "if(!frameElem) { return; }" + "var frame = frameElem.contentWindow;" + "var submit = function() { " + "if(arguments.length == 1 && arguments[0] == 1) { " + (postUpload ? "Ice.InputFileIdPostUpload = '" + id + "'; Ice.InputFileIdPreUpload = null;" : "return;") + " } " + "else { " + (preUpload ? "Ice.InputFileIdPreUpload = '" + id + "'; Ice.InputFileIdPostUpload = null;" : "return;") + " } try { if(document.getElementById('" + id + "')) { '" + id + "'.asExtendedElement().form().submit(); } } catch (e) { logger.warn('Form not available', e); } finally { Ice.InputFileIdPreUpload = null; Ice.InputFileIdPostUpload = null; } };" + "frame.document.getElementsByTagName('form')[0].onsubmit = submit;" + "var uploadEnd = function() { submit(1); setTimeout(register, 200); };" + "if (frame.attachEvent) { frame.attachEvent('onunload', uploadEnd); } else { frame.onunload = uploadEnd; } };" + "setTimeout(register, 300);"), null);
            writer.endElement("script");
        }
        FileInfo fileInfo = c.getFileInfo();
        if (log.isDebugEnabled()) {
            log.debug((Object)("InputFileRenderer  fileInfo: " + fileInfo));
        }
        if (fileInfo.isFailed()) {
            int status;
            File file;
            String fileName = fileInfo.getFileName();
            if (fileName == null && (file = fileInfo.getFile()) != null) {
                fileName = file.getName();
            }
            if (fileName == null) {
                fileName = "";
            }
            if ((status = fileInfo.getStatus()) == 3) {
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.INVALID_FILE", new Object[]{fileName}));
            } else if (status == 4) {
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.SIZE_LIMIT_EXCEEDED"));
            } else if (status == 5) {
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.UNKNOWN_SIZE"));
            } else if (status == 6) {
                String fileNamePattern = uploadConfig.getFileNamePattern();
                if (fileNamePattern == null) {
                    fileNamePattern = "";
                }
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.INVALID_NAME_PATTERN", new Object[]{fileName, fileNamePattern}));
            } else if (status == 7) {
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.UNSPECIFIED_NAME"));
            } else if (status == 8) {
                context.addMessage(id, MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.INVALID_CONTENT_TYPE"));
            }
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        InputFile inputFile = (InputFile)component;
        inputFile.setPreUpload(false);
        inputFile.setPostUpload(false);
        Map parameter = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        String preUpload = (String)parameter.get("ice.inputFile.preUpload");
        String postUpload = (String)parameter.get("ice.inputFile.postUpload");
        if (preUpload != null && preUpload.length() > 0 && preUpload.equals(clientId)) {
            inputFile.reset();
            inputFile.setPreUpload(true);
            inputFile.queueEvent((FacesEvent)new InputFileProgressEvent((UIComponent)inputFile));
        }
        if (postUpload != null && postUpload.length() > 0 && postUpload.equals(clientId)) {
            inputFile.setPostUpload(true);
            inputFile.queueEvent((FacesEvent)new InputFileProgressEvent((UIComponent)inputFile));
        }
    }
}

