/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.axes;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.axes.ChildTestIterator;
import org.htmlunit.xpath.axes.PredicatedNodeTest;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.patterns.NodeTest;
import org.htmlunit.xpath.xml.dtm.DTMAxisTraverser;

public class UnionChildIterator
extends ChildTestIterator {
    private PredicatedNodeTest[] m_nodeTests = null;

    public UnionChildIterator() {
        super((DTMAxisTraverser)null);
    }

    public void addNodeTest(PredicatedNodeTest test) {
        if (null == this.m_nodeTests) {
            this.m_nodeTests = new PredicatedNodeTest[1];
            this.m_nodeTests[0] = test;
        } else {
            PredicatedNodeTest[] tests = this.m_nodeTests;
            int len = this.m_nodeTests.length;
            this.m_nodeTests = new PredicatedNodeTest[len + 1];
            System.arraycopy(tests, 0, this.m_nodeTests, 0, len);
            this.m_nodeTests[len] = test;
        }
        test.exprSetParent(this);
    }

    @Override
    public short acceptNode(int n) {
        XPathContext xctxt = this.getXPathContext();
        try {
            xctxt.pushCurrentNode(n);
            for (PredicatedNodeTest pnt : this.m_nodeTests) {
                XObject score = pnt.execute(xctxt, n);
                if (score == NodeTest.SCORE_NONE) continue;
                if (pnt.getPredicateCount() > 0) {
                    if (!pnt.executePredicates(n, xctxt)) continue;
                    short s = 1;
                    return s;
                }
                short s = 1;
                return s;
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        finally {
            xctxt.popCurrentNode();
        }
        return 3;
    }
}

