/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.service;

import java.util.Collection;
import java.util.List;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.crud.service.ReactiveTreeSortEntityService;
import org.hswebframework.web.dictionary.entity.DictionaryItemEntity;
import org.hswebframework.web.dictionary.event.ClearDictionaryCacheEvent;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.id.IDGenerator;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDictionaryItemService
extends GenericReactiveCrudService<DictionaryItemEntity, String>
implements ReactiveTreeSortEntityService<DictionaryItemEntity, String> {
    @Autowired
    public ApplicationEventPublisher eventPublisher;

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.SNOW_FLAKE_STRING;
    }

    public void setChildren(DictionaryItemEntity entity, List<DictionaryItemEntity> children) {
        entity.setChildren(children);
    }

    public Mono<Integer> insert(Publisher<DictionaryItemEntity> entityPublisher) {
        return super.insert(this.fillOrdinal(entityPublisher)).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> insertBatch(Publisher<? extends Collection<DictionaryItemEntity>> entityPublisher) {
        return super.insertBatch(this.fillCollectionOrdinal(entityPublisher)).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> updateById(String id, Mono<DictionaryItemEntity> entityPublisher) {
        return super.updateById((Object)id, entityPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return super.deleteById(idPublisher).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public Mono<SaveResult> save(Publisher<DictionaryItemEntity> entityPublisher) {
        return super.save(this.fillOrdinal(entityPublisher)).doOnSuccess(r -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of()));
    }

    public ReactiveUpdate<DictionaryItemEntity> createUpdate() {
        return super.createUpdate().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public ReactiveDelete createDelete() {
        return super.createDelete().onExecute((ignore, r) -> r.doOnSuccess(l -> this.eventPublisher.publishEvent((Object)ClearDictionaryCacheEvent.of())));
    }

    public Publisher<? extends Collection<DictionaryItemEntity>> fillCollectionOrdinal(Publisher<? extends Collection<DictionaryItemEntity>> entityPublisher) {
        return Flux.from(entityPublisher).flatMap(collection -> this.fillOrdinal((Publisher<DictionaryItemEntity>)Flux.fromIterable((Iterable)collection)).collectList());
    }

    public Flux<DictionaryItemEntity> fillOrdinal(Publisher<DictionaryItemEntity> publisher) {
        return Flux.from(publisher).groupBy(DictionaryItemEntity::getDictId).flatMap(group -> group.collectList().flatMapMany(list -> {
            boolean isAllNull = list.stream().allMatch(item -> item.getOrdinal() == null);
            boolean notNull = list.stream().allMatch(item -> item.getOrdinal() != null);
            if (notNull) {
                return Flux.fromIterable((Iterable)list).doOnNext(DictionaryItemEntity::generateId);
            }
            if (isAllNull) {
                return this.fillOrdinal((String)group.key(), (List<DictionaryItemEntity>)list);
            }
            return Mono.error(() -> new BusinessException("error.ordinal_can_not_null"));
        }));
    }

    private Flux<DictionaryItemEntity> fillOrdinal(String dictId, List<DictionaryItemEntity> list) {
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new StaticMethodReferenceColumn[]{DictionaryItemEntity::getOrdinal})).where(DictionaryItemEntity::getDictId, (Object)dictId)).orderBy(new SortOrder[]{SortOrder.desc(DictionaryItemEntity::getOrdinal)})).fetchOne().map(DictionaryItemEntity::getOrdinal).defaultIfEmpty((Object)-1).flatMapMany(maxOrdinal -> Flux.fromIterable((Iterable)list).index().map(tp2 -> {
            DictionaryItemEntity item = (DictionaryItemEntity)((Object)((Object)((Object)tp2.getT2())));
            int ordinal = ((Long)tp2.getT1()).intValue() + maxOrdinal + 1;
            item.setOrdinal(ordinal);
            item.generateId();
            return item;
        }));
    }
}

