/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.entity;

import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericTreeSortSupportEntity;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.i18n.I18nSupportUtils;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.i18n.MultipleI18nSupportEntity;
import org.hswebframework.web.utils.DigestUtils;
import org.springframework.util.StringUtils;

@Table(name="s_dictionary_item", indexes={@Index(name="idx_dic_item_dic_id", columnList="dict_id"), @Index(name="idx_dic_item_ordinal", columnList="ordinal"), @Index(name="idx_dic_item_path", columnList="path")})
@Comment(value="\u6570\u636e\u5b57\u5178\u9009\u9879")
public class DictionaryItemEntity
extends GenericTreeSortSupportEntity<String>
implements EnumDict<String>,
MultipleI18nSupportEntity {
    @Column(name="dict_id", length=64, updatable=false, nullable=false)
    @Schema(description="\u6570\u636e\u5b57\u5178ID")
    private String dictId;
    @Column
    @Schema(description="\u9009\u9879\u540d\u79f0")
    private String name;
    @Column
    @Schema(description="\u503c")
    private String value;
    @Column
    @Schema(description="\u6587\u672c\u5185\u5bb9")
    private String text;
    @Column(name="value_type")
    @Schema(description="\u503c\u7c7b\u578b")
    private String valueType;
    @Column
    @Schema(description="\u72b6\u6001\uff0c0\u7981\u7528\uff0c1\u542f\u7528")
    @DefaultValue(value="1")
    private Byte status;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String describe;
    @Column(name="search_code")
    @Schema(description="\u68c0\u7d22\u7801")
    private String searchCode;
    @Column(name="ordinal", nullable=false, updatable=false)
    @Schema(description="\u5e8f\u5217\u53f7,\u540c\u4e00\u4e2a\u5b57\u5178\u4e2d\u7684\u9009\u9879\u4e0d\u80fd\u91cd\u590d,\u4e14\u4e0d\u80fd\u4fee\u6539.")
    private Integer ordinal;
    @Schema(description="\u5b50\u8282\u70b9")
    private List<DictionaryItemEntity> children;
    @Schema(description="\u56fd\u9645\u5316\u914d\u7f6e")
    @Column
    @JsonCodec
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    private Map<String, Map<String, String>> i18nMessages;

    public int ordinal() {
        return this.ordinal == null ? 0 : this.ordinal;
    }

    public String getI18nText() {
        return this.getI18nMessage("text", this.text);
    }

    public void putI18nText(String i18nKey) {
        this.putI18nText(i18nKey, LocaleUtils.getSupportLocales());
    }

    public void putI18nText(String i18nKey, Collection<Locale> locales) {
        this.i18nMessages = I18nSupportUtils.putI18nMessages((String)i18nKey, (String)"text", locales, null, this.i18nMessages);
    }

    public String getI18nName() {
        return this.getI18nMessage("name", this.name);
    }

    public String getI18nDescribe() {
        return this.getI18nMessage("describe", this.describe);
    }

    public void generateId() {
        if (StringUtils.hasText((String)((String)this.getId()))) {
            return;
        }
        this.setId(DictionaryItemEntity.generateId(this.getDictId(), this.getOrdinal()));
    }

    public static String generateId(String dictId, Integer ordinal) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"|", dictId, ordinal.toString()));
    }

    public Object getWriteJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getId());
        jsonObject.put("name", (Object)this.getI18nName());
        jsonObject.put("dictId", (Object)this.getDictId());
        jsonObject.put("value", (Object)this.getValue());
        jsonObject.put("text", (Object)this.getI18nText());
        jsonObject.put("ordinal", (Object)this.getOrdinal());
        jsonObject.put("sortIndex", (Object)this.getSortIndex());
        jsonObject.put("parentId", this.getParentId());
        jsonObject.put("path", (Object)this.getPath());
        jsonObject.put("mask", (Object)this.getMask());
        jsonObject.put("searchCode", (Object)this.getSearchCode());
        jsonObject.put("status", (Object)this.getStatus());
        jsonObject.put("describe", (Object)this.getI18nDescribe());
        return jsonObject;
    }

    public String getDictId() {
        return this.dictId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public String getValueType() {
        return this.valueType;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getSearchCode() {
        return this.searchCode;
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    public List<DictionaryItemEntity> getChildren() {
        return this.children;
    }

    public Map<String, Map<String, String>> getI18nMessages() {
        return this.i18nMessages;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setSearchCode(String searchCode) {
        this.searchCode = searchCode;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public void setChildren(List<DictionaryItemEntity> children) {
        this.children = children;
    }

    public void setI18nMessages(Map<String, Map<String, String>> i18nMessages) {
        this.i18nMessages = i18nMessages;
    }
}

