/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.configuration;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(prefix="hsweb.dict")
public class DictionaryProperties {
    private static final Logger log = LoggerFactory.getLogger(DictionaryProperties.class);
    private Set<String> enumPackages = new HashSet<String>();

    public Stream<Class<?>> doScanEnum() {
        HashSet<String> packages = new HashSet<String>(this.enumPackages);
        packages.add("org.hswebframework.web");
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        return packages.parallelStream().flatMap(arg_0 -> DictionaryProperties.lambda$doScanEnum$1((ResourcePatternResolver)resourcePatternResolver, metadataReaderFactory, arg_0));
    }

    public Set<String> getEnumPackages() {
        return this.enumPackages;
    }

    public void setEnumPackages(Set<String> enumPackages) {
        this.enumPackages = enumPackages;
    }

    private static /* synthetic */ Stream lambda$doScanEnum$1(ResourcePatternResolver resourcePatternResolver, CachingMetadataReaderFactory metadataReaderFactory, String enumPackage) {
        Resource[] resources;
        String path = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)enumPackage) + "/**/*.class";
        log.info("scan enum dict package:{}", (Object)path);
        try {
            resources = resourcePatternResolver.getResources(path);
        }
        catch (IOException e) {
            log.warn("scan enum dict package:{} error:", (Object)path, (Object)e);
            return Stream.empty();
        }
        return Stream.of(resources).map(resource -> {
            try {
                MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
                String name = reader.getClassMetadata().getClassName();
                Class clazz = ClassUtils.forName((String)name, null);
                if (clazz.isEnum() && EnumDict.class.isAssignableFrom(clazz)) {
                    return clazz;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull);
    }
}

